/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector;

import com.digiwin.athenai.nl2sql.connector.bo.ResultSetBO;
import java.util.List;
import java.util.Map;

public class MdTableGenerator {
    public static String generateTable(String[][] resultArr) {
        if (resultArr == null || resultArr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        for (String col : resultArr[0]) {
            sb.append(col).append(" | ");
        }
        sb.append("\n");
        sb.append("|---".repeat(resultArr[0].length)).append("|\n");
        for (int i = 1; i < resultArr.length; ++i) {
            sb.append("| ");
            for (String cell : resultArr[i]) {
                sb.append(cell).append(" | ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String generateTable(ResultSetBO resultSetBO) {
        List<String> column = resultSetBO.getColumn();
        List<Map<String, String>> data = resultSetBO.getData();
        String[][] resultArr = new String[data.size() + 1][column.size()];
        int idxR = 0;
        resultArr[idxR++] = column.toArray(new String[0]);
        for (Map<String, String> kv : data) {
            String[] row = new String[column.size()];
            int idxC = 0;
            for (String c : column) {
                row[idxC++] = kv.get(c);
            }
            resultArr[idxR++] = row;
        }
        return MdTableGenerator.generateTable(resultArr);
    }
}

