/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector.accessor.defaults;

import com.digiwin.athenai.nl2sql.connector.AbstractJdbcDdl;
import com.digiwin.athenai.nl2sql.connector.DBConnectionPool;
import com.digiwin.athenai.nl2sql.connector.SqlExecutor;
import com.digiwin.athenai.nl2sql.connector.accessor.Accessor;
import com.digiwin.athenai.nl2sql.connector.bo.ColumnInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.DatabaseInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.DbQueryParameter;
import com.digiwin.athenai.nl2sql.connector.bo.ForeignKeyInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.ResultSetBO;
import com.digiwin.athenai.nl2sql.connector.bo.SchemaInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.TableInfoBO;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.connector.support.DdlFactory;
import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessor
implements Accessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAccessor.class);
    private final DdlFactory ddlFactory;
    private final DBConnectionPool dbConnectionPool;

    protected AbstractAccessor(DdlFactory ddlFactory, DBConnectionPool dbConnectionPool) {
        this.dbConnectionPool = dbConnectionPool;
        this.ddlFactory = ddlFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T accessDb(DbConfig dbConfig, String method, DbQueryParameter param) throws Exception {
        try (Connection connection = this.getConnection(dbConfig);){
            AbstractJdbcDdl ddlExecutor = (AbstractJdbcDdl)this.ddlFactory.getDdlExecutor(dbConfig);
            switch (method) {
                case "showDatabases": {
                    List<DatabaseInfoBO> list = ddlExecutor.showDatabases(connection);
                    return (T)list;
                }
                case "showSchemas": {
                    List<SchemaInfoBO> list = ddlExecutor.showSchemas(connection);
                    return (T)list;
                }
                case "showTables": {
                    List<TableInfoBO> list = ddlExecutor.showTables(connection, param.getSchema(), param.getTablePattern());
                    return (T)list;
                }
                case "fetchTables": {
                    List<TableInfoBO> list = ddlExecutor.fetchTables(connection, param.getSchema(), param.getTables());
                    return (T)list;
                }
                case "showColumns": {
                    List<ColumnInfoBO> list = ddlExecutor.showColumns(connection, param.getSchema(), param.getTable());
                    return (T)list;
                }
                case "showForeignKeys": {
                    List<ForeignKeyInfoBO> list = ddlExecutor.showForeignKeys(connection, param.getSchema(), param.getTables());
                    return (T)list;
                }
                case "sampleColumn": {
                    List<String> list = ddlExecutor.sampleColumn(connection, param.getSchema(), param.getTable(), param.getColumn());
                    return (T)list;
                }
                case "scanTable": {
                    ResultSetBO resultSetBO = ddlExecutor.scanTable(connection, param.getSchema(), param.getTable());
                    return (T)resultSetBO;
                }
                case "executeSqlAndReturnObject": {
                    ResultSetBO resultSetBO = SqlExecutor.executeSqlAndReturnObject(connection, param.getSchema(), param.getSql());
                    return (T)resultSetBO;
                }
            }
            throw new UnsupportedOperationException("Unknown method: " + method);
        }
        catch (Exception e) {
            logger.error("Error accessing database with method: {}", (Object)method, (Object)e);
            throw e;
        }
    }

    @Override
    public List<DatabaseInfoBO> showDatabases(DbConfig dbConfig) throws Exception {
        return (List)this.accessDb(dbConfig, "showDatabases", null);
    }

    @Override
    public List<SchemaInfoBO> showSchemas(DbConfig dbConfig) throws Exception {
        return (List)this.accessDb(dbConfig, "showSchemas", null);
    }

    @Override
    public List<TableInfoBO> showTables(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (List)this.accessDb(dbConfig, "showTables", param);
    }

    @Override
    public List<TableInfoBO> fetchTables(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (List)this.accessDb(dbConfig, "fetchTables", param);
    }

    @Override
    public List<ColumnInfoBO> showColumns(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (List)this.accessDb(dbConfig, "showColumns", param);
    }

    @Override
    public List<ForeignKeyInfoBO> showForeignKeys(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (List)this.accessDb(dbConfig, "showForeignKeys", param);
    }

    @Override
    public List<String> sampleColumn(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (List)this.accessDb(dbConfig, "sampleColumn", param);
    }

    @Override
    public ResultSetBO scanTable(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (ResultSetBO)this.accessDb(dbConfig, "scanTable", param);
    }

    @Override
    public ResultSetBO executeSqlAndReturnObject(DbConfig dbConfig, DbQueryParameter param) throws Exception {
        return (ResultSetBO)this.accessDb(dbConfig, "executeSqlAndReturnObject", param);
    }

    public Connection getConnection(DbConfig config) {
        return this.dbConnectionPool.getConnection(config);
    }
}

