/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.component.PromptAsistant;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.nl2sql.constant.PromptConstant;
import com.digiwin.athenai.nl2sql.entity.TableInfo;
import com.digiwin.athenai.nl2sql.mapper.TableInfoMapper;
import com.digiwin.athenai.support.MyTokenTextSplitter;
import com.digiwin.athenai.utils.IdUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.transformer.splitter.TokenTextSplitter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TableInfoService
extends ServiceImpl<TableInfoMapper, TableInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableInfoService.class);
    @Autowired
    AiEmbeddingService aiEmbeddingService;
    @Autowired
    PromptAsistant promptAsistant;
    MyTokenTextSplitter myTokenTextSplitter = new MyTokenTextSplitter();

    public List<String> findCodeByAgent(String agent) {
        return ((TableInfoMapper)this.baseMapper).findCodeByAgent(agent);
    }

    public List<TableInfo> findByCodes(List<String> codes, String agent) {
        return ((TableInfoMapper)this.baseMapper).findByCodes(codes, agent);
    }

    public TableInfo findByCode(String code, String agent) {
        return ((TableInfoMapper)this.baseMapper).findByCode(code, agent);
    }

    public Integer deleteByCode(String code, String agent) {
        return ((TableInfoMapper)this.baseMapper).deleteByCode(code, agent);
    }

    public TableInfo addTableSummary(String agent, TableInfo tableInfo) {
        Assert.notNull((Object)tableInfo.getCode(), (String)"table code is null");
        Assert.notNull((Object)tableInfo.getPrompt(), (String)"table prompt is null");
        String content = tableInfo.getPrompt();
        if (content.length() > MyTokenTextSplitter.chunkSize) {
            content = this.text2keywords(content);
        }
        return this.addTable(agent, tableInfo, content);
    }

    @Transactional
    public TableInfo addTable(String agent, TableInfo tableInfo, String prompt) {
        Assert.notNull((Object)tableInfo.getCode(), (String)"table code is null");
        Assert.notNull((Object)tableInfo.getPrompt(), (String)"table prompt is null");
        tableInfo.setAgent(agent);
        ArrayList<String> vectors = new ArrayList<String>();
        ArrayList<KnowledgeBase> knowledgeBases = new ArrayList<KnowledgeBase>();
        String content = tableInfo.getPrompt();
        if (StringUtils.isNotEmpty((CharSequence)prompt)) {
            content = prompt;
        }
        if (content.length() > MyTokenTextSplitter.chunkSize) {
            List texts = this.myTokenTextSplitter.split(content);
            for (String t : texts) {
                KnowledgeBase knowledgeBase = TableInfoService.tokb(tableInfo, t);
                knowledgeBases.add(knowledgeBase);
                vectors.add(knowledgeBase.getVectorId());
            }
        } else {
            KnowledgeBase knowledgeBase = TableInfoService.tokb(tableInfo, tableInfo.getPrompt());
            knowledgeBases.add(knowledgeBase);
            vectors.add(knowledgeBase.getVectorId());
        }
        tableInfo.setVectorId(StringUtils.join(vectors, (String)","));
        TableInfo infoIndb = ((TableInfoMapper)this.baseMapper).findByCode(tableInfo.getCode(), agent);
        if (null != infoIndb) {
            ((TableInfoMapper)this.baseMapper).deleteById(infoIndb.getId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{infoIndb.getVectorId()})) {
                String[] ids = infoIndb.getVectorId().split(",");
                this.aiEmbeddingService.deleteDocuments(agent, Arrays.asList(ids));
            }
        }
        this.aiEmbeddingService.addKnowledge(agent, knowledgeBases);
        this.save((Object)tableInfo);
        return tableInfo;
    }

    public String text2keywords(String query) {
        return this.promptAsistant.process(PromptConstant.nl2sql_table2Keyword(), Map.of("question", query));
    }

    public static void main(String[] args) {
        TokenTextSplitter splitter = TokenTextSplitter.builder().withChunkSize(8000).withMaxNumChunks(10000).withKeepSeparator(true).build();
    }

    private static KnowledgeBase tokb(TableInfo tableInfo, String text) {
        KnowledgeBase base = new KnowledgeBase();
        base.setVectorId(IdUtil.uuid());
        base.setCode(tableInfo.getCode());
        base.setName(tableInfo.getName());
        base.setPrompt(text);
        base.setType("table");
        return base;
    }
}

