/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.service.ali;

import com.alibaba.fastjson.JSON;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.dto.schema.SchemaDTO;
import com.digiwin.athenai.nl2sql.service.SqlAsistantService;
import com.digiwin.athenai.nl2sql.service.ali.BaseSchemaService;
import com.digiwin.athenai.nl2sql.utils.PromptHelper;
import com.digiwin.athenai.utils.DateTimeUtil;
import com.digiwin.athenai.utils.MarkdownParser;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliNl2sqlService {
    private static final Logger logger = LoggerFactory.getLogger(AliNl2sqlService.class);
    @Autowired
    SqlAsistantService sqlAsistantService;
    @Autowired
    AiChatService aiChatService;
    @Autowired
    BaseSchemaService schemaService;

    public String nl2sql(String query, String agent) throws Exception {
        DbConfig dbConfig = this.sqlAsistantService.getDbConfig(agent);
        logger.info("Starting nl2sql conversion for query: {}", (Object)query);
        List<Document> evidenceDocuments = this.sqlAsistantService.evidences(agent, query);
        List<String> evidences = evidenceDocuments.stream().map(Document::getText).collect(Collectors.toList());
        logger.info("Extracted {} evidences for nl2sql", (Object)evidences.size());
        SchemaDTO schemaDTO = this.select(query, evidences, agent, dbConfig);
        String sql = this.generateSql(evidences, query, schemaDTO, null, null, dbConfig);
        logger.info("Nl2sql conversion completed. Generated SQL: {}", (Object)sql);
        return sql;
    }

    public SchemaDTO select(String query, List<String> evidenceList, String agentId, DbConfig dbConfig) throws Exception {
        logger.debug("Starting schema selection for query: {} with {} evidences and agentId: {}", new Object[]{query, evidenceList.size(), agentId});
        List<String> keywords = this.extractKeywords(query, evidenceList);
        logger.debug("Using {} keywords for schema selection", (Object)(keywords != null ? keywords.size() : 0));
        SchemaDTO schemaDTO = this.schemaService.mixRagForAgent(agentId, query, keywords, dbConfig);
        logger.debug("Retrieved schema with {} tables", (Object)(schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0));
        SchemaDTO result = this.fineSelect(schemaDTO, query, evidenceList, null);
        logger.debug("Fine selection completed, final schema has {} tables", (Object)(result.getTable() != null ? result.getTable().size() : 0));
        return result;
    }

    public List<String> extractKeywords(String query, List<String> evidenceList) {
        logger.debug("Extracting keywords from query: {} with {} evidences", (Object)query, (Object)evidenceList.size());
        StringBuilder queryBuilder = new StringBuilder(query);
        for (String evidence : evidenceList) {
            queryBuilder.append(evidence).append("\u3002");
        }
        query = queryBuilder.toString();
        String prompt = PromptHelper.buildQueryToKeywordsPrompt(query);
        logger.debug("Calling LLM for keyword extraction");
        String content = this.aiChatService.simpleCall(prompt);
        List keywords = (List)new Gson().fromJson(content, new TypeToken<List<String>>(this){}.getType());
        logger.debug("Extracted {} keywords: {}", (Object)(keywords != null ? keywords.size() : 0), (Object)keywords);
        return keywords;
    }

    public SchemaDTO fineSelect(SchemaDTO schemaDTO, String query, List<String> evidenceList, String sqlGenerateSchemaMissingAdvice) {
        logger.debug("Fine selecting schema for query: {} with {} evidences", (Object)query, (Object)evidenceList.size());
        String prompt = PromptHelper.buildMixSelectorPrompt(evidenceList, query, schemaDTO);
        logger.debug("Calling LLM for schema fine selection");
        String content = this.aiChatService.simpleCall(prompt);
        HashSet<String> selectedTables = new HashSet<String>();
        if (sqlGenerateSchemaMissingAdvice != null) {
            logger.debug("Adding tables from schema missing advice");
            selectedTables.addAll(this.fineSelect(schemaDTO, sqlGenerateSchemaMissingAdvice));
        }
        if (content != null && !content.trim().isEmpty()) {
            List tableList;
            String jsonContent = MarkdownParser.extractText((String)content);
            try {
                tableList = (List)new Gson().fromJson(jsonContent, new TypeToken<List<String>>(this){}.getType());
            }
            catch (Exception e) {
                logger.error("Failed to parse fine selection response: {}", (Object)jsonContent, (Object)e);
                throw new IllegalStateException(jsonContent);
            }
            if (tableList != null && !tableList.isEmpty()) {
                selectedTables.addAll(tableList.stream().map(String::toLowerCase).collect(Collectors.toSet()));
                int originalTableCount = schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0;
                schemaDTO.getTable().removeIf(table -> !selectedTables.contains(table.getName().toLowerCase()));
                int finalTableCount = schemaDTO.getTable() != null ? schemaDTO.getTable().size() : 0;
                logger.debug("Fine selection completed: {} -> {} tables, selected tables: {}", new Object[]{originalTableCount, finalTableCount, selectedTables});
            }
        }
        return schemaDTO;
    }

    public Set<String> fineSelect(SchemaDTO schemaDTO, String sqlGenerateSchemaMissingAdvice) {
        logger.debug("Fine selecting tables based on advice: {}", (Object)sqlGenerateSchemaMissingAdvice);
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String prompt = " \u5efa\u8bae\uff1a" + sqlGenerateSchemaMissingAdvice + " \n \u8bf7\u6309\u7167\u5efa\u8bae\u8fdb\u884c\u8fd4\u56de\u76f8\u5173\u8868\u7684\u540d\u79f0\uff0c\u53ea\u8fd4\u56de\u5efa\u8bae\u4e2d\u63d0\u5230\u7684\u8868\u540d\uff0c\u8fd4\u56de\u683c\u5f0f\u4e3a\uff1a[\"a\",\"b\",\"c\"] \n " + schemaInfo;
        logger.debug("Calling LLM for table selection with advice");
        String content = this.aiChatService.simpleCall(prompt);
        if (content != null && !content.trim().isEmpty()) {
            List tableList;
            String jsonContent = MarkdownParser.extractText((String)content);
            try {
                tableList = (List)new Gson().fromJson(jsonContent, new TypeToken<List<String>>(this){}.getType());
            }
            catch (Exception e) {
                logger.error("Failed to parse table selection response: {}", (Object)jsonContent, (Object)e);
                throw new IllegalStateException(jsonContent);
            }
            if (tableList != null && !tableList.isEmpty()) {
                Set<String> selectedTables = tableList.stream().map(String::toLowerCase).collect(Collectors.toSet());
                logger.debug("Selected {} tables based on advice: {}", (Object)selectedTables.size(), selectedTables);
                return selectedTables;
            }
        }
        logger.debug("No tables selected based on advice");
        return new HashSet<String>();
    }

    public String generateSql(List<String> evidenceList, String query, SchemaDTO schemaDTO, String sql, String exceptionMessage, DbConfig dbConfig) throws Exception {
        logger.info("Generating SQL for query: {}, hasExistingSql: {}", (Object)query, (Object)(sql != null && !sql.isEmpty() ? 1 : 0));
        System.out.println("schema:");
        System.out.println(JSON.toJSONString((Object)schemaDTO, (boolean)true));
        String dateTimeExtractPrompt = PromptHelper.buildDateTimeExtractPrompt(query);
        logger.debug("Extracting datetime expressions");
        String content = this.aiChatService.simpleCall(dateTimeExtractPrompt);
        ArrayList<String> dateTimeList = new ArrayList<String>();
        LocalDate now = LocalDate.now();
        List expressionList = (List)new Gson().fromJson(content, new TypeToken<List<String>>(this){}.getType());
        List dateTimeExpressions = DateTimeUtil.buildDateExpressions((List)expressionList, (LocalDate)now);
        for (String dateTimeExpression : dateTimeExpressions) {
            if (dateTimeExpression.endsWith("=")) continue;
            dateTimeList.add(dateTimeExpression.replace("=", "\u6307\u7684\u662f"));
        }
        expressionList.addAll(dateTimeList);
        logger.debug("Processed {} datetime expressions", (Object)dateTimeList.size());
        String newSql = "";
        if (sql != null && !sql.isEmpty()) {
            logger.debug("Using SQL error fixer for existing SQL: {}", (Object)sql);
            String errorFixerPrompt = PromptHelper.buildSqlErrorFixerPrompt(query, dbConfig, schemaDTO, evidenceList, sql, exceptionMessage);
            newSql = this.aiChatService.simpleCall(errorFixerPrompt);
            logger.info("SQL error fixing completed");
        } else {
            logger.debug("Generating new SQL from scratch");
            List<String> prompts = PromptHelper.buildMixSqlGeneratorPrompt(query, dbConfig, schemaDTO, evidenceList);
            newSql = this.aiChatService.simpleCall(prompts.get(0), prompts.get(1));
            logger.info("New SQL generation completed");
        }
        String result = MarkdownParser.extractRawText((String)newSql).trim();
        logger.info("Final generated SQL: {}", (Object)result);
        return result;
    }
}

