/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.service.ali;

import com.digiwin.athenai.domain.AiSearchRequest;
import com.digiwin.athenai.nl2sql.dto.SchemaInitRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;

public abstract class BaseVectorStoreService {
    protected abstract EmbeddingModel getEmbeddingModel();

    public List<Double> embedDouble(String text) {
        return this.convertToDoubleList(this.getEmbeddingModel().embed(text));
    }

    public Boolean schema(SchemaInitRequest schemaInitRequest) throws Exception {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<Float> embedFloat(String text) {
        return this.convertToFloatList(this.getEmbeddingModel().embed(text));
    }

    public List<Document> getDocuments(String query, String vectorType) {
        AiSearchRequest request = new AiSearchRequest();
        request.setQuery(query);
        request.setVectorType(vectorType);
        request.setTopK(100);
        return new ArrayList<Document>(this.searchWithVectorType(request));
    }

    public List<Document> getDocumentsForAgent(String agentId, String query, String vectorType) {
        return this.getDocuments(query, vectorType);
    }

    public abstract List<Document> searchWithVectorType(AiSearchRequest var1);

    public abstract List<Document> searchWithFilter(AiSearchRequest var1);

    public List<Document> searchTableByNameAndVectorType(AiSearchRequest searchRequestDTO) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected List<Double> convertToDoubleList(float[] array) {
        return IntStream.range(0, array.length).mapToDouble(i -> array[i]).boxed().collect(Collectors.toList());
    }

    protected List<Float> convertToFloatList(float[] array) {
        return IntStream.range(0, array.length).mapToObj(i -> Float.valueOf(array[i])).collect(Collectors.toList());
    }
}

