/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.controller;

import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.fastjson2.JSON;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.domain.AiRequest;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.entity.AgentScenario;
import com.digiwin.athenai.nl2sql.povo.InitSchemaDto;
import com.digiwin.athenai.nl2sql2.Nl2sqlMcpTool2;
import com.digiwin.athenai.nl2sql2.SimpleSqlGraphService;
import com.digiwin.athenai.nl2sql2.dto.E10Table;
import com.digiwin.athenai.nl2sql2.service.ScenarioParseService;
import com.digiwin.athenai.nl2sql2.service.SchemaService;
import com.digiwin.athenai.service.AgentKnowledgeService;
import com.digiwin.athenai.service.AgentScenarioService;
import com.digiwin.athenai.tool.TimeTool;
import com.digiwin.athenai.utils.FilesUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scenario"})
public class AgentScenarioTestController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentScenarioTestController.class);
    @Autowired
    AgentKnowledgeService knowledgeService;
    @Autowired
    AgentScenarioService agentScenarioService;
    String agent = "e10_80_1";
    String agent_scenario = this.agent + "_scenario";
    @Autowired
    SimpleSqlGraphService simpleSqlGraphService;
    @Autowired
    ScenarioParseService scenarioParseService;
    @Autowired
    SchemaService schemaService;
    @Autowired
    AiChatService aiChatService;
    @Autowired
    AiEmbeddingService embeddingService;
    @Autowired
    MessageChatMemoryAdvisor messageChatMemoryAdvisor;

    @GetMapping(value={"test01"})
    public Object test01(@RequestParam String query) {
        Object obj = "ok";
        AgentScenario scenario = (AgentScenario)this.agentScenarioService.findByAgentAndCode(this.agent, "e1030202query");
        obj = this.scenarioParseService.scenarioSqlQuery(scenario, query);
        return obj;
    }

    @PostMapping(value={"test02"})
    public Object test02(Map<String, Object> param, @RequestHeader(value="chatId") String chatId) throws GraphRunnerException {
        Object obj = "ok";
        Map<String, Object> result = this.simpleSqlGraphService.invoke(param);
        System.out.println(result);
        obj = result.get("result");
        return obj;
    }

    @GetMapping(value={"addTables"})
    public Object addTables() {
        ArrayList<String> successTables = new ArrayList<String>();
        ArrayList<String> failedTables = new ArrayList<String>();
        String obj = "ok";
        List<E10Table> tables = AgentScenarioTestController.docs3();
        for (E10Table e10Table : tables) {
            try {
                this.schemaService.saveSchema1(this.agent, e10Table);
                successTables.add(e10Table.getTableName());
                System.out.println("\u6210\u529f:" + e10Table.getTableName());
            }
            catch (Exception e) {
                System.err.println("\u5931\u8d25:" + e10Table.getTableName());
                failedTables.add(e10Table.getTableName());
                e.printStackTrace();
            }
        }
        System.out.println("successTables:" + successTables.size());
        System.out.println(successTables);
        System.err.println("failedTables:" + failedTables.size());
        System.out.println(failedTables);
        return obj;
    }

    @GetMapping(value={"initTables"})
    public Object initTables() {
        String obj = "ok";
        InitSchemaDto dto = new InitSchemaDto();
        dto.setAgent(this.agent);
        this.schemaService.initSchema1(dto);
        return obj;
    }

    @PostMapping(value={"/chat1"})
    @Operation(summary="DashScope Flux Chat")
    public String chat1(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("agent", "e10_80_1");
        param.put("query", prompt);
        param.put("chat_memory_conversation_id", chatId);
        Map<String, Object> result = this.simpleSqlGraphService.invoke(param);
        System.out.println(result);
        String obj = (String)result.get("result");
        return obj;
    }

    @PostMapping(value={"/chat"})
    @Operation(summary="DashScope Flux Chat")
    public String chat2(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        log.info("Starting stream search for query: {} with agentId: {} with chatId {}", new Object[]{prompt, this.agent, chatId});
        String system = "\u4f60\u662f\u4e00\u4e2a\u4e13\u4e1aERP\u52a9\u624b\uff1a\u7cbe\u901aERP\u7cfb\u7edf\uff0c\u7cbe\u51c6\u7406\u89e3\u7528\u6237\u4e1a\u52a1\u610f\u56fe\u5e76\u81ea\u52a8\u5b8c\u6210\u4efb\u52a1.\n## \u6838\u5fc3\u80fd\u529b\n   - \u901a\u8fc7\u5de5\u5177\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u5e76\u5206\u6790,\u590d\u6742\u4efb\u52a1\u53ef\u4ee5\u62c6\u5206\u4e3a\u591a\u4e2a\u67e5\u8be2\u5e76\u6c47\u603b\u5206\u6790\n## \u5c55\u793a\u89c4\u8303\n   - \u591a\u6761\u7ed3\u679c\uff1a\u4f7f\u7528Markdown\u8868\u683c\u5f62\u5f0f\u5c55\u793a\n## \u4e1a\u52a1\u77e5\u8bc6\ngraph TB\nE10(E10ERP\u7cfb\u7edf)-->e101[\u516c\u5171\u7ba1\u7406\u7cfb\u7edf]\nE10-->e102[\u4f9b\u5e94\u94fe\u7ba1\u7406\u7cfb\u7edf]\nE10-->e103[\u751f\u4ea7\u5236\u9020\u7ba1\u7406\u7cfb\u7edf]\nE10-->e104[\u8d22\u52a1\u7ba1\u7406\u7cfb\u7edf]\n\ne101-->e10101[\u57fa\u7840\u6570\u636e]\ne101-->e10102[\u7cfb\u7edf\u53c2\u6570]\ne101-->e10103[\u7cfb\u7edf\u8bbe\u5b9a]\ne101-->e10104[\u7ba1\u7406\u5de5\u5177]\ne101-->e10105[\u76d1\u63a7\u9884\u8b66]\n\ne102-->e10201[\u5b58\u8d27\u7ba1\u7406]\ne102-->e10202[\u91c7\u8d2d\u7ba1\u7406]\ne102-->e10203[\u9500\u552e\u5206\u9500]\ne102-->e10204[\u6761\u7801\u7ba1\u7406]\ne102-->e10205[\u5e8f\u5217\u53f7\u7ba1\u7406]\ne102-->e10206[\u51fa\u53e3\u7ba1\u7406]\ne102-->e10207[\u552e\u80a1\u7ba1\u7406]\ne102-->e10208[\u7269\u6d41\u76f4\u8fde]\n\ne103-->e10301[BOM\u7ba1\u7406]\ne103-->e10302[\u5de5\u5355\u7ba1\u7406]\ne103-->e10303[\u5de5\u827a\u7ba1\u7406]\ne103-->e10304[\u8ba1\u5212\u7ba1\u7406]\ne103-->e10305[\u751f\u4ea7\u6392\u7a0b]\ne103-->e10306[\u4ea4\u6599\u6392\u7a0b]\ne103-->e10307[\u8d28\u91cf\u7ba1\u7406]\ne103-->e10308[\u8bbe\u5907\u7ba1\u7406]\n\ne104-->e10401[\u603b\u8d26]\ne104-->e10402[\u5e94\u6536\u7ba1\u7406]\ne104-->e10403[\u5e94\u4ed8\u7ba1\u7406]\ne104-->e10404[\u51fa\u7eb3\u7ba1\u7406]\ne104-->e10405[\u8d44\u4ea7\u7ba1\u7406]\ne104-->e10406[\u751f\u4ea7\u6210\u672c]\ne104-->e10407[\u81ea\u52a8\u5206\u5f55]\ne104-->e10408[\u5408\u5e76\u62a5\u8868]\ne104-->e10409[\u5229\u6da6\u4e2d\u5fc3]\ne104-->e10410[\u94f6\u4f01\u76f4\u8fde]\ne104-->e10411[\u7a0e\u52a1\u53d1\u7968\u7ba1\u7406]\ne104-->e10412[\u8d8a\u5357\u8d22\u52a1\u89e3\u51b3\u65b9\u6848]\ne104-->e10413[\u7a0e\u52a1\u53d1\u7968\u7ba1\u7406]\ne104-->e10414[\u7968\u636e\u7ba1\u7406]\n";
        AiRequest aiRequest = new AiRequest();
        aiRequest.setAgent(this.agent);
        aiRequest.setSystem(system);
        aiRequest.setUseChatMemory(true);
        String stringFlux = this.aiChatService.createChatClient(aiRequest).prompt().user(prompt).tools(new Object[]{new TimeTool()}).tools(new Object[]{new Nl2sqlMcpTool2(this.scenarioParseService)}).toolContext(Map.of("agent", this.agent)).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId)).call().content();
        return stringFlux;
    }

    @GetMapping(value={"addScenario"})
    public Object addScenario() {
        String obj = "ok";
        AgentScenario s1 = new AgentScenario();
        s1.setCategory("e1030202");
        s1.setCode("e1030202query");
        s1.setName("\u5de5\u5355\u67e5\u8be2");
        s1.setPrompt("\u5de5\u5355\u67e5\u8be2");
        s1.setAccessStr("[{\"effect\":\"allow\",\"subject\":{\"user\":\"zhangsan\"}},{\"effect\":\"allow\",\"subject\":{\"role\":\"manager\"}}]");
        s1.setCoreTableStr("[\"MO\",\"ITEM\",\"UNIT\",\"ITEM_FEATURE\",\"ITEM_ROUTING\",\"ADMIN_UNIT\",\"ITEM_LOT\",\"WAREHOUSE\",\"PROJECT\",\"SUPPLY_SYNERGY\",\"EMPLOYEE\",\"USER\",\"MO_D\",\"ADP_PS_D\",\"ADP_PS_MO\",\"WRITEOFFS_IR\",\"WRITEOFFS_MR\",\"COMBINE_TEMPLATE\",\"COST_DOC\",\"INNER_TRANSFER_DOC_D\",\"ISSUE_RECEIPT_MO\",\"ISSUE_RECEIPT_D\",\"MO_DAILY_PRODUCTION_QTY\",\"MO_DEMAND\",\"MO_PRODUCT\",\"MO_ISSUED_SETS\",\"MO_BATCH_CHANGE_D\",\"MO_CHANGE\",\"MO_DISPATCHED\",\"MO_RECEIPT_D\",\"MO_ROUTING\",\"TO_DISPATCH\",\"MO_ROUTING_PRODUCT\",\"MO_SPLIT\"]");
        s1.setCoreTableRelationStr("[\"MO.ITEM_ID=ITEM.ITEM_ID\",\"MO.UNIT_ID=UNIT.UNIT_ID\",\"MO.ITEM_FEATURE_ID=ITEM_FEATURE.ITEM_FEATURE_ID\",\"MO.ITEM_ROUTING_ID=ITEM_ROUTING.ITEM_ROUTING_ID\",\"MO.ADMIN_UNIT_ID=ADMIN_UNIT.ADMIN_UNIT_ID\",\"MO.ITEM_LOT_ID=ITEM_LOT.ITEM_LOT_ID\",\"MO.WAREHOUSE_ID=WAREHOUSE.WAREHOUSE_ID\",\"MO.PROJECT_ID=PROJECT.PROJECT_ID\",\"MO.SYNERGY_ID=SUPPLY_SYNERGY.SYNERGY_ID\",\"MO.Owner_Dept=ADMIN_UNIT.ADMIN_UNIT_ID\",\"MO.Owner_Emp=EMPLOYEE.EMPLOYEE_ID\",\"MO.CreateBy=USER.USER_ID\",\"MO.ModifiedBy=USER.USER_ID\",\"MO_D.ITEM_ID=MO.ITEM_ID\",\"ADP_PS_D.MO_ID=MO.MO_ID\",\"ADP_PS_MO.MO_ID=MO.MO_ID\",\"WRITEOFFS_IR.MO_ID=MO.MO_ID\",\"WRITEOFFS_MR.MO_ID=MO.MO_ID\",\"COMBINE_TEMPLATE.MO_ID=MO.MO_ID\",\"COST_DOC.MO_ID=MO.MO_ID\",\"INNER_TRANSFER_DOC_D.MO_ID=MO.MO_ID\",\"ISSUE_RECEIPT_MO.MO_ID=MO.MO_ID\",\"ISSUE_RECEIPT_D.MO_ID=MO.MO_ID\",\"MO_DAILY_PRODUCTION_QTY.MO_ID=MO.MO_ID\",\"MO_DEMAND.MO_ID=MO.MO_ID\",\"MO_PRODUCT.MO_ID=MO.MO_ID\",\"MO_ISSUED_SETS.MO_ID=MO.MO_ID\",\"MO_BATCH_CHANGE_D.MO_ID=MO.MO_ID\",\"MO_CHANGE.MO_ID=MO.MO_ID\",\"MO_DISPATCHED.MO_ID=MO.MO_ID\",\"MO_RECEIPT_D.MO_ID=MO.MO_ID\",\"MO_ROUTING.MO_ID=MO.MO_ID\",\"TO_DISPATCH.MO_ID=MO.MO_ID\",\"MO_ROUTING_PRODUCT.MO_ID=MO.MO_ID\",\"MO_SPLIT.MO_ID=MO.MO_ID\"]");
        s1.setToolStr("[\n        {\n            \"function\": {\n                \"description\": \"\u901a\u8fc7\u751f\u6210\u5e76\u6267\u884csql\u63d0\u4f9b\u4e1a\u52a1\u6570\u636e\u67e5\u8be2,\u9700\u8981\u63d0\u4f9b\u6bd4\u8f83\u5b8c\u5584\u7684\u8bed\u4e49\",\n                \"name\": \"businessQueryService\",\n                \"parameters\": {\n                    \"properties\": {\n                        \"query\": {\n                            \"description\": \"\u6267\u884c\u64cd\u4f5c\u7684\u63cf\u8ff0\",\n                            \"type\": \"string\"\n                        },\n                        \"scenario\": {\n                            \"description\": \"\u573a\u666fcode\",\n                            \"type\": \"string\"\n                        }\n                    },\n                    \"required\": [\n                        \"query\",\"scenario\"\n                    ],\n                    \"type\": \"object\"\n                }\n            },\n            \"type\": \"function\"\n        }\n    ]\n");
        s1.setSqlDemoStr("[\u95ee\u9898]\n\u67e5\u8be2\u6700\u8fd1\u5b8c\u5de5\u7684\u5de5\u5355\n[\u8f93\u51fa]\n{\"sql\":\"SELECT t0.MO_ID AS MO_ID, t0.ITEM_DESCRIPTION AS ITEM_DESCRIPTION, t0.ITEM_SPECIFICATION AS ITEM_SPECIFICATION, t0.BOM_VERSION_TIMES AS BOM_VERSION_TIMES, t0.BOM_DATE AS BOM_DATE, t0.URGENT AS URGENT, t0.STATUS AS STATUS, t0.LOT_MO_FLAG AS LOT_MO_FLAG, t0.PLAN_QTY AS PLAN_QTY, t0.REQ_QTY AS REQ_QTY, t0.COMPLETED_QTY AS COMPLETED_QTY, t0.SCRAP_QTY AS SCRAP_QTY, t0.DESTROYED_QTY AS DESTROYED_QTY, t0.PLAN_START_DATE AS PLAN_START_DATE, t0.PLAN_COMPLETE_DATE AS PLAN_COMPLETE_DATE, t0.ACTUAL_START_DATE AS ACTUAL_START_DATE, t0.ACTUAL_COMPLETE_DATE AS ACTUAL_COMPLETE_DATE FROM MO AS t0 WHERE t0.STATUS = 'Y' and t0.ACTUAL_COMPLETE_DATE >= DATEADD(day, -7, GETDATE()) ORDER BY t0.ACTUAL_COMPLETE_DATE DESC\",\"tables\":[\"MO\"]}\n\n[\u95ee\u9898]\n\u67e5\u770b\u5df2\u5ba1\u6838\u7684\u5de5\u5355\n[\u8f93\u51fa]\n{\"sql\":\"SELECT t0.MO_ID AS MO_ID, t0.ITEM_DESCRIPTION AS ITEM_DESCRIPTION, t0.ITEM_SPECIFICATION AS ITEM_SPECIFICATION, t0.BOM_VERSION_TIMES AS BOM_VERSION_TIMES, t0.BOM_DATE AS BOM_DATE, t0.URGENT AS URGENT, t0.STATUS AS STATUS, t0.LOT_MO_FLAG AS LOT_MO_FLAG, t0.PLAN_QTY AS PLAN_QTY, t0.REQ_QTY AS REQ_QTY, t0.COMPLETED_QTY AS COMPLETED_QTY, t0.SCRAP_QTY AS SCRAP_QTY, t0.DESTROYED_QTY AS DESTROYED_QTY, t0.ApproveStatus AS ApproveStatus, t0.ApproveDate AS ApproveDate, t1.USER_NAME as USER_NAME FROM [MO] AS t0 left join [USER] t1 on t0.ApproveBy=t1.USER_ID WHERE t0.ApproveStatus = 'Y' ORDER BY t0.ApproveStatus DESC\",\"tables\":[\"MO\",\"USER\"]}\n\n[\u95ee\u9898]\n\u67e5\u8be223\u5e7410\u6708\u672a\u5ba1\u6838\u7684\u5de5\u5355\uff0c\u663e\u793a\u5de5\u5382\u3001\u7269\u6599\u3001\u5de5\u827a\u3001\u9879\u76ee\u3001\u6570\u91cf\u3001\u72b6\u6001\u3001\u6765\u6e90\u3001\u90e8\u95e8\u7b49\uff0c\u5e76\u6309\u5de5\u5355\u53f7\u548c\u65e5\u671f\u6392\u5e8f\uff0c\u4ee5\u4fbf\u5ba1\u6279\u548c\u751f\u4ea7\u8ba1\u5212\u7ba1\u7406\n[\u8f93\u51fa]\n{\"sql\":\"SELECT t0.MO_ID, t1.PLANT_NAME AS Factory, t0.ITEM_DESCRIPTION AS Material, t9.ROUTING_DES AS Process, t15.PROJECT_NAME AS Project, t0.PLAN_QTY AS Quantity, t0.STATUS AS Status, CASE t0.SOURCE_ID_RTK WHEN 'SUPPLIER' THEN t6.SUPPLIER_NAME WHEN 'WORK_CENTER' THEN t7.WORK_CENTER_NAME END AS Source, t13.ADMIN_UNIT_NAME AS Department, t19.USER_NAME AS Approver FROM MO AS t0 LEFT JOIN PLANT AS t1 ON t0.Owner_Org_ROid = t1.PLANT_ID LEFT JOIN ITEM_ROUTING AS t9 ON t0.ITEM_ROUTING_ID = t9.ITEM_ROUTING_ID LEFT JOIN PROJECT AS t15 ON t0.PROJECT_ID = t15.PROJECT_ID LEFT JOIN SUPPLIER AS t6 ON t0.SOURCE_ID_ROid = t6.SUPPLIER_BUSINESS_ID LEFT JOIN WORK_CENTER AS t7 ON t0.SOURCE_ID_ROid = t7.WORK_CENTER_ID LEFT JOIN ADMIN_UNIT AS t13 ON t0.Owner_Dept = t13.ADMIN_UNIT_ID LEFT JOIN [USER] AS t19 ON t0.ApproveBy = t19.USER_ID WHERE t0.DOC_DATE >= '2023-10-01' AND t0.DOC_DATE <= '2023-10-31' AND t0.ApproveStatus = 'N' ORDER BY t0.DOC_NO ASC, t0.DOC_DATE ASC;\",\"tables\":[\"MO\",\"PLANT\",\"ITEM_ROUTING\",\"PROJECT\",\"SUPPLIER\",\"WORK_CENTER\",\"ADMIN_UNIT\",\"USER\"]}\n\n");
        s1.setAgent(this.agent);
        AgentScenario s2 = new AgentScenario();
        s2.setCategory("e1030202");
        s2.setCode("e1030202create");
        s2.setName("\u5de5\u5355\u521b\u5efa");
        s2.setPrompt("\u5de5\u5355\u521b\u5efa");
        s2.setAgent(this.agent);
        AgentScenario s3 = new AgentScenario();
        s3.setCategory("e1030202");
        s3.setCode("e1030202approve");
        s3.setName("\u5de5\u5355\u5ba1\u6838");
        s3.setPrompt("\u5de5\u5355\u5ba1\u6838");
        s3.setAgent(this.agent);
        AgentScenario s4 = new AgentScenario();
        s4.setCategory("e1030202");
        s4.setCode("e1030202print");
        s4.setName("\u5de5\u5355\u6253\u5370");
        s4.setPrompt("\u5de5\u5355\u6253\u5370");
        s4.setAgent(this.agent);
        AgentScenario s5 = new AgentScenario();
        s5.setCategory("e1030202");
        s5.setCode("e1030202send");
        s5.setName("\u5de5\u5355\u53d1\u6599");
        s5.setPrompt("\u5de5\u5355\u53d1\u6599");
        s5.setAgent(this.agent);
        AgentScenario s6 = new AgentScenario();
        s6.setCategory("e1030202");
        s6.setCode("e1030202query_zhiling");
        s6.setName("\u5236\u4ee4\u5de5\u5355\u67e5\u8be2");
        s6.setPrompt("\u5236\u4ee4\u5de5\u5355\u67e5\u8be2");
        s6.setAgent(this.agent);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s1, null);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s2, null);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s3, null);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s4, null);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s5, null);
        this.agentScenarioService.addKnowledge(this.agent_scenario, (KnowledgeBase)s6, null);
        return obj;
    }

    public static List<E10Table> docs3() {
        String content = FilesUtils.loadContent((String)"D:\\test\\e10-etl.txt");
        String[] tables = content.split("=//=//=");
        ArrayList<E10Table> list = new ArrayList<E10Table>();
        for (String t : tables) {
            E10Table table = (E10Table)JSON.parseObject((String)t, E10Table.class);
            list.add(table);
        }
        return list;
    }
}

