/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.digiwin.athenai.advisor.HalfMessageChatMemoryAdvisor;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.nl2sql.component.SqlMcpComponent;
import com.digiwin.athenai.nl2sql.service.Nl2SqlService;
import com.digiwin.athenai.tool.TimeTool;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.SimpleLoggerAdvisor;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.vectorstore.QuestionAnswerAdvisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneralProcessNode
implements NodeAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralProcessNode.class);
    String systemPrompt = "    # \u4f60\u662f\u4e00\u4e2a\u4e13\u4e1aERP\u52a9\u624b\uff1a\u7cbe\u901aERP\u7cfb\u7edf\uff0c\u7cbe\u51c6\u7406\u89e3\u7528\u6237\u4e1a\u52a1\u610f\u56fe\u5e76\u81ea\u52a8\u5b8c\u6210\u4efb\u52a1.\n    ## \u6838\u5fc3\u80fd\u529b\n       - \u901a\u8fc7\u5de5\u5177\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u5e76\u5206\u6790,\u590d\u6742\u4efb\u52a1\u53ef\u4ee5\u62c6\u5206\u4e3a\u591a\u4e2a\u67e5\u8be2\u5e76\u6c47\u603b\u5206\u6790\n    ## \u5c55\u793a\u89c4\u8303\n       - \u591a\u6761\u7ed3\u679c\uff1a\u4f7f\u7528Markdown\u8868\u683c\u5f62\u5f0f\u5c55\u793a\n";
    @Autowired
    AiChatService chatService;
    @Autowired
    ChatMemory chatMemory;
    @Autowired
    private Nl2SqlService nl2SqlService;
    @Autowired
    AiEmbeddingService embeddingService;

    public Map<String, Object> apply(OverAllState state) throws Exception {
        System.out.println("GeneralProcessNode.......................................");
        String agent = (String)state.value("agent", (Object)"");
        String chatId = (String)state.value("chat_memory_conversation_id", (Object)"");
        String query = (String)state.value("query", (Object)"");
        ChatClient.Builder builder = this.chatService.getChatClientBuilder();
        builder.defaultSystem(this.systemPrompt).defaultAdvisors(new Advisor[]{new SimpleLoggerAdvisor()});
        ChatClient chatClient = builder.build();
        ChatClient.ChatClientRequestSpec spec = chatClient.prompt();
        if (StringUtils.isNotEmpty((CharSequence)chatId)) {
            spec.advisors(new Advisor[]{HalfMessageChatMemoryAdvisor.builder((ChatMemory)this.chatMemory).logBefore(false).build()}).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId));
        } else {
            spec.user(query);
        }
        spec.tools(new Object[]{new TimeTool()}).tools(new Object[]{new SqlMcpComponent(this.nl2SqlService)}).toolContext(Map.of("agent", agent));
        spec.advisors(new Advisor[]{new QuestionAnswerAdvisor(this.embeddingService.vectorStore(agent))});
        String content = spec.call().content();
        return Map.of("result", content);
    }
}

