/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.digiwin.athenai.advisor.HalfMessageChatMemoryAdvisor;
import com.digiwin.athenai.component.AiChatService;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PrepareInfoNode
implements NodeAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrepareInfoNode.class);
    String systemPrompt = "\u8bf7\u6839\u636e\u4e0a\u4e0b\u6587\u4fe1\u606f\u5206\u6790\u51fa\u7528\u6237\u7684\u610f\u56fe,\u76f4\u63a5\u8f93\u51fa\u7ed3\u679c\n\u4e3e\u4f8b:\n\u8f93\u51651:\u5e2e\u6211\u67e5\u770b\u7cfb\u7edf\u4e2d\u672a\u5ba1\u6838\u7684\u5de5\u5355\n\u8f93\u51fa1:\u67e5\u770b\u672a\u5ba1\u6838\u5de5\u5355\n\u8f93\u51652:\u4f60\u597d,\u4f60\u80fd\u5e2e\u6211\u67e5\u8be2\u6700\u8fd1\u6307\u5b9a\u5b8c\u5de5\u7684\u5236\u4ee4\u5de5\u5355\u5417?\n\u8f93\u51fa2:\u67e5\u770b\u4e00\u5468\u5185\u6307\u5b9a\u5b8c\u5de5\u7684\u5236\u4ee4\u5de5\u5355\n";
    @Autowired
    AiChatService chatService;
    @Autowired
    ChatMemory chatMemory;

    public Map<String, Object> apply(OverAllState state) throws Exception {
        String agent = (String)state.value("agent", (Object)"");
        String chatId = (String)state.value("chat_memory_conversation_id", (Object)"");
        String query = (String)state.value("query", (Object)"");
        Assert.hasLength((String)agent, (String)"agent is null");
        Assert.hasLength((String)query, (String)"query is null");
        ChatClient.Builder builder = this.chatService.getChatClientBuilder();
        builder.defaultOptions(ChatOptions.builder().temperature(Double.valueOf(0.2)).build()).defaultSystem(this.systemPrompt);
        ChatClient chatClient = builder.build();
        ChatClient.ChatClientRequestSpec spec = chatClient.prompt(query);
        if (StringUtils.isNotEmpty((CharSequence)chatId)) {
            spec.advisors(new Advisor[]{HalfMessageChatMemoryAdvisor.builder((ChatMemory)this.chatMemory).logAfter(false).build()}).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId));
        }
        String content = spec.call().content();
        System.out.println("\u610f\u56fe==" + content);
        return Map.of("query1", query);
    }
}

