/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.digiwin.athenai.entity.AgentScenario;
import com.digiwin.athenai.nl2sql.dto.SqlResultDo;
import com.digiwin.athenai.nl2sql.entity.TableInfo;
import com.digiwin.athenai.nl2sql.service.TableInfoService;
import com.digiwin.athenai.nl2sql.utils.Nl2SqlUtils;
import com.digiwin.athenai.nl2sql2.service.ScenarioParseService;
import com.digiwin.athenai.service.AgentScenarioService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class ScenarioParseNode
implements NodeAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScenarioParseNode.class);
    public static final PromptTemplate PROMPT_TEMPLATE = new PromptTemplate("   \u6839\u636e\u8f93\u5165\u7684\u5de5\u5177\u63cf\u8ff0\u548c\u4e0a\u4e0b\u6587\u53c2\u6570\u8fdb\u884c\u89e3\u6790,\u4e3a\u5de5\u5177\u7ec4\u7ec7\u5165\u53c2,\u751f\u6210json\u7ed3\u6784\u7ed3\u679c\u4e0d\u8981\u4efb\u4f55\u63cf\u8ff0.\n   \u6837\u4f8b:\n   [\u8f93\u5165]\n   \u5de5\u5177\u63cf\u8ff0:\n   ```\n   [\n                {\n                    \"type\": \"function\",\n                    \"function\": {\n                        \"name\": \"get_current_weather\",\n                        \"description\": \"\u5f53\u4f60\u60f3\u67e5\u8be2\u6307\u5b9a\u57ce\u5e02\u7684\u5929\u6c14\u65f6\u975e\u5e38\u6709\u7528\u3002\",\n                        \"parameters\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"location\": {\n                                    \"type\": \"string\",\n                                    \"description\": \"\u57ce\u5e02\u6216\u53bf\u533a\uff0c\u6bd4\u5982\u5317\u4eac\u5e02\u3001\u676d\u5dde\u5e02\u3001\u4f59\u676d\u533a\u7b49\u3002\",\n                                }\n                            },\n                            \"required\": [\"location\"],\n                        },\n                    },\n                },\n            ]\n            ```\n\n            \u4e0a\u4e0b\u6587\u53c2\u6570\n            ```\n            [\"location\":\"\u4e0a\u6d77\",\"name\":\"\u5f20\u4e09\"]\n            ```\n\n            [\u8f93\u51fa]\n            ```\n            [\n                             {\n                                 \"function\": {\n                                     \"arguments\": \"{\\\"location\\\": \\\"\u4e0a\u6d77\\\"}\",\n                                     \"name\": \"get_current_weather\"\n                                 },\n                                 \"type\": \"function\",\n                                 \"index\": 0\n                             }\n                         ]\n            ```\n");
    @Autowired
    AgentScenarioService agentScenarioService;
    @Autowired
    ScenarioParseService scenarioParseService;
    @Autowired
    @Lazy
    TableInfoService tableInfoService;

    public Map<String, Object> apply(OverAllState state) throws Exception {
        String agent = (String)state.value("agent", (Object)"");
        String query = (String)state.value("query", (Object)"");
        String query1 = (String)state.value("query1", (Object)"");
        String scenarioResult = (String)state.value("STATE_SCENARIO_RESULT", (Object)"");
        Assert.hasLength((String)scenarioResult, (String)"scenario code is null");
        AgentScenario scenario = (AgentScenario)this.agentScenarioService.findByAgentAndCode(agent, scenarioResult);
        Assert.notNull((Object)scenario, (String)("can not find AgentScenario by code " + scenarioResult));
        SqlResultDo result = this.scenarioParseService.scenarioSqlQuery(scenario, query1);
        if (!CollectionUtils.isEmpty(result.getTables())) {
            List<TableInfo> tableInfos = this.tableInfoService.findByCodes(result.getTables(), agent);
            String schemaStr = Nl2SqlUtils.formatTablePrompt(tableInfos);
            result.setSchemas(schemaStr);
        }
        return Map.of("STATE_SQL_RESULT", result);
    }
}

