/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.digiwin.athenai.advisor.HalfMessageChatMemoryAdvisor;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.nl2sql.dto.SqlResultDo;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TableDataOutputNode
implements NodeAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableDataOutputNode.class);
    @Autowired
    AiChatService chatService;
    @Autowired
    ChatMemory chatMemory;
    public static final PromptTemplate PROMPT_TEMPLATE = new PromptTemplate("\u6839\u636e\u6570\u636e\u5e93schema\u548csql\u4fe1\u606f\u91cd\u65b0\u5bf9\u6570\u636e\u8fdb\u884c\u8c03\u6574,\u4f7f\u5f97\u5bf9\u4eba\u5c55\u793a\u66f4\u52a0\u53cb\u597d\n\u8981\u6c42\n1.\u4ec5\u5c55\u793a\u6570\u636e\u4e0d\u8981\u6dfb\u52a0\u989d\u5916\u8bf4\u660e\n2.\u5c55\u793a\u6570\u636e\u5c3d\u91cf\u63a7\u5236\u572815\u5217\u4ee5\u5185\n3.\u72b6\u6001\u5b57\u6bb5\u663e\u793a\u5b83\u7684\u540d\u79f0\u800c\u4e0d\u662f\u503c\n\n\u3010\u6570\u636e\u5e93schema\u3011\n{schema_info}\n\n\u3010sql\u3011\n{sql}\n\n\u3010\u6570\u636e\u3011\n{data}\n\n");

    public Map<String, Object> apply(OverAllState state) throws Exception {
        String chatId = (String)state.value("chat_memory_conversation_id", (Object)"");
        SqlResultDo dto = (SqlResultDo)state.value("STATE_SQL_RESULT", SqlResultDo.class).get();
        Assert.notNull((Object)dto, (String)"\u672a\u83b7\u5f97\u6b63\u786e\u7684\u6267\u884c\u7ed3\u679c");
        String output = PROMPT_TEMPLATE.render(Map.of("schema_info", dto.getSchemas(), "sql", dto.getSql(), "data", dto.getData()));
        ChatClient.Builder builder = this.chatService.getChatClientBuilder();
        ChatClient chatClient = builder.build();
        ChatClient.ChatClientRequestSpec spec = chatClient.prompt(output);
        if (StringUtils.isNotEmpty((CharSequence)chatId)) {
            spec.advisors(new Advisor[]{HalfMessageChatMemoryAdvisor.builder((ChatMemory)this.chatMemory).logBefore(false).userHis(false).build()}).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId));
        }
        String content = spec.call().content();
        return Map.of("result", content);
    }
}

