/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql2.service;

import ch.qos.logback.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.nl2sql.entity.ColumnInfo;
import com.digiwin.athenai.nl2sql.entity.TableInfo;
import com.digiwin.athenai.nl2sql.povo.InitSchemaDto;
import com.digiwin.athenai.nl2sql.service.ColumnInfoService;
import com.digiwin.athenai.nl2sql.service.TableInfoService;
import com.digiwin.athenai.nl2sql2.dto.E10Column;
import com.digiwin.athenai.nl2sql2.dto.E10DicProperty;
import com.digiwin.athenai.nl2sql2.dto.E10Table;
import com.digiwin.athenai.utils.ClassPathPromptLoader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchemaService {
    @Autowired
    ColumnInfoService columnInfoService;
    @Autowired
    TableInfoService tableInfoService;
    @Autowired
    AiEmbeddingService embeddingService;
    @Autowired
    AiChatService aiChatService;

    @Transactional
    public void saveSchema1(String agent, E10Table table) {
        TableInfo info = SchemaService.toTable1(agent, table);
        String str = SchemaService.tableDesc().render(Map.of("schema", info.getPrompt()));
        String desc = this.aiChatService.simpleCall(str);
        info.setDescription(desc);
        String code = table.getTableName();
        this.tableInfoService.deleteByCode(code, agent);
        this.tableInfoService.save((Object)info);
    }

    public void initSchema1(InitSchemaDto dto) {
        String agent = dto.getAgent();
        List<String> tables = dto.getTables();
        if (CollectionUtils.isEmpty(tables)) {
            tables = this.tableInfoService.findCodeByAgent(agent);
        }
        ArrayList<String> failed = new ArrayList<String>();
        ArrayList<String> success = new ArrayList<String>();
        for (String table : tables) {
            try {
                TableInfo tableInfo = this.tableInfoService.findByCode(table, agent);
                this.initTable(agent, tableInfo);
                success.add(table);
                System.out.println("\u6210\u529f:" + table);
            }
            catch (Exception e) {
                failed.add(table);
                System.out.println("\u5931\u8d25:" + table);
                e.printStackTrace();
            }
        }
        System.out.println("success:" + success.size());
        System.out.println(success);
        System.out.println("failed:" + failed.size());
        System.out.println(failed);
    }

    @Transactional
    public void saveSchema2(String agent, E10Table table) {
        String code = table.getTableName();
        this.tableInfoService.deleteByCode(code, agent);
        this.columnInfoService.deleteByTable(code, agent);
        TableInfo tableInfo = this.toTable(agent, table);
        List<ColumnInfo> columnInfos = this.toColumns(agent, table);
        this.tableInfoService.save((Object)tableInfo);
        this.columnInfoService.saveBatch(columnInfos);
    }

    public void initSchema2(InitSchemaDto dto) {
        String agent = dto.getAgent();
        List<String> tables = dto.getTables();
        if (CollectionUtils.isEmpty(tables)) {
            tables = this.tableInfoService.findCodeByAgent(agent);
        }
        ArrayList<String> failed = new ArrayList<String>();
        ArrayList<String> success = new ArrayList<String>();
        for (String table : tables) {
            try {
                TableInfo tableInfo = this.tableInfoService.findByCode(table, agent);
                List<ColumnInfo> columnInfos = this.columnInfoService.findByTableCode(table, agent);
                this.initTableAndColumns(agent, tableInfo, columnInfos);
                success.add(table);
            }
            catch (Exception e) {
                failed.add(table);
                System.out.println("\u521d\u59cb\u5316\u8868\u5931\u8d25:" + table);
                e.printStackTrace();
            }
        }
        System.out.println("success:" + success.size());
        System.out.println(success);
        System.out.println("failed:" + failed.size());
        System.out.println(failed);
    }

    public static TableInfo toTable1(String agent, E10Table table) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbf = new StringBuilder();
        sb.append("**").append(table.getDescription()).append("**\r\n");
        sb.append("\u8868\u540d:").append(table.getTableName()).append("\r\n");
        sb.append("\u4e1a\u52a1\u4e3b\u952e:").append(table.getBusinessPrimaryKey()).append("\r\n");
        sb.append("| \u5b57\u6bb5ID |\u5b57\u6bb5\u663e\u793a\u540d\u79f0| \u6570\u636e\u7c7b\u578b | \u63cf\u8ff0 | \u5916\u952e |").append("\r\n");
        sb.append("|--------|----------|----------|----------|------|").append("\r\n");
        for (E10Column column : table.getColumns()) {
            if (null != column.getDescription() && column.getDescription().startsWith("\u81ea\u5b9a\u4e49\u5b57\u6bb5")) continue;
            Object desc = " ";
            Object reference = "";
            if (null != column.getReferenceToName() && StringUtils.isNotBlank((CharSequence)column.getReferenceToNameProperty())) {
                reference = column.getReferenceToName() + "." + column.getReferenceToNameProperty();
            }
            if (null != column.getLogicalFk() && StringUtils.isNotBlank((CharSequence)column.getLogicalFk().getColumnName())) {
                reference = column.getLogicalFk().getTableName() + "." + column.getLogicalFk().getColumnName();
            }
            desc = (String)desc + StringUtil.nullStringToEmpty((String)column.getFieldMeaning());
            if (!org.springframework.util.CollectionUtils.isEmpty(column.getDicPropertyList())) {
                StringBuilder sblist = new StringBuilder();
                sblist.append(" \u652f\u6301\u8303\u56f4:[");
                for (E10DicProperty property : column.getDicPropertyList()) {
                    sblist.append("").append(property.getId()).append(":").append(property.getDisplayName()).append(",");
                }
                sblist.append("]");
                desc = (String)desc + sblist.toString();
            }
            String col = String.format("| %s | %s | %s | %s | %s |", column.getName(), StringUtil.nullStringToEmpty((String)column.getDescription()), StringUtil.nullStringToEmpty((String)column.getDbType()), desc, reference);
            sb.append(col).append("\r\n");
            if (!StringUtils.isNotBlank((CharSequence)reference)) continue;
            sbf.append((String)reference).append(",");
        }
        sb.append("\r\n");
        TableInfo tableInfo = new TableInfo();
        tableInfo.setAgent(agent);
        tableInfo.setType("table");
        tableInfo.setCode(table.getTableName());
        tableInfo.setName(table.getDescription());
        tableInfo.setPrompt(sb.toString());
        tableInfo.setPrimaryKey(table.getBusinessPrimaryKey());
        ArrayList<CallSite> foreignKeys = new ArrayList<CallSite>();
        for (E10Column column : table.getColumns()) {
            if (null == column.getLogicalFk()) continue;
            String fk = table.getTableName() + "." + column.getName() + "=" + column.getLogicalFk().getTableName() + "." + column.getLogicalFk().getColumnName();
            foreignKeys.add((CallSite)((Object)fk));
        }
        tableInfo.setForeignKey(String.join((CharSequence)"\u3001", foreignKeys));
        return tableInfo;
    }

    private void initTable(String agent, TableInfo tableInfo) {
        FilterExpressionBuilder builder1 = new FilterExpressionBuilder();
        Filter.Expression expression1 = builder1.and(builder1.eq("vectorType", (Object)"table"), builder1.eq("name", (Object)tableInfo.getCode())).build();
        FilterExpressionBuilder builder2 = new FilterExpressionBuilder();
        Filter.Expression expression2 = builder2.and(builder2.eq("vectorType", (Object)"tableSummary"), builder2.eq("name", (Object)tableInfo.getCode())).build();
        this.embeddingService.deleteDocuments(agent, expression1);
        this.embeddingService.deleteDocuments(agent, expression2);
        ArrayList<Document> documents = new ArrayList<Document>();
        Document tableDoc = Document.builder().id(UUID.randomUUID().toString()).text(tableInfo.getPrompt()).metadata(Map.of("name", tableInfo.getCode(), "description", tableInfo.getName(), "vectorType", "table", "foreignKey", StringUtil.nullStringToEmpty((String)tableInfo.getForeignKey()), "primaryKey", StringUtil.nullStringToEmpty((String)tableInfo.getPrimaryKey()))).build();
        documents.add(tableDoc);
        Document tableDoc2 = Document.builder().id(UUID.randomUUID().toString()).text(tableInfo.getDescription()).metadata(Map.of("name", tableInfo.getCode(), "description", tableInfo.getName(), "vectorType", "tableSummary", "foreignKey", StringUtil.nullStringToEmpty((String)tableInfo.getForeignKey()), "primaryKey", StringUtil.nullStringToEmpty((String)tableInfo.getPrimaryKey()))).build();
        documents.add(tableDoc2);
        this.embeddingService.addDocuments(agent, documents);
    }

    private void initTableAndColumns(String agent, TableInfo tableInfo, List<ColumnInfo> columnInfos) {
        FilterExpressionBuilder builder1 = new FilterExpressionBuilder();
        Filter.Expression expression1 = builder1.and(builder1.eq("vectorType", (Object)"table"), builder1.eq("name", (Object)tableInfo.getCode())).build();
        FilterExpressionBuilder builder2 = new FilterExpressionBuilder();
        Filter.Expression expression2 = builder2.and(builder2.eq("vectorType", (Object)"column"), builder2.eq("tableName", (Object)tableInfo.getCode())).build();
        this.embeddingService.deleteDocuments(agent, expression1);
        this.embeddingService.deleteDocuments(agent, expression2);
        ArrayList<Document> documents = new ArrayList<Document>();
        System.out.println(JSON.toJSONString((Object)((Object)tableInfo)));
        Document tableDoc = Document.builder().id(UUID.randomUUID().toString()).text(tableInfo.getDescription()).metadata(Map.of("name", tableInfo.getCode(), "description", tableInfo.getName(), "vectorType", "table", "foreignKey", StringUtil.nullStringToEmpty((String)tableInfo.getForeignKey()), "primaryKey", StringUtil.nullStringToEmpty((String)tableInfo.getPrimaryKey()))).build();
        documents.add(tableDoc);
        for (ColumnInfo columnInfo : columnInfos) {
            String name = columnInfo.getName();
            if (null == name || name.equalsIgnoreCase("\u4e3b\u952e") || name.startsWith("\u81ea\u5b9a\u4e49\u5b57\u6bb5") || null != columnInfo.getForeignKey() || null == columnInfo.getDbType()) continue;
            System.out.println(JSON.toJSONString((Object)((Object)columnInfo)));
            Document columnDoc = Document.builder().id(UUID.randomUUID().toString()).text(columnInfo.getDescription()).metadata(Map.of("name", columnInfo.getCode(), "description", columnInfo.getName(), "vectorType", "column", "type", columnInfo.getDbType(), "tableName", tableInfo.getCode())).build();
            documents.add(columnDoc);
        }
        this.embeddingService.addDocuments(agent, documents);
    }

    private TableInfo toTable(String agent, E10Table table) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setAgent(agent);
        tableInfo.setType("table");
        tableInfo.setCode(table.getTableName());
        tableInfo.setName(table.getDescription());
        tableInfo.setDescription(table.getDescription());
        tableInfo.setPrimaryKey(table.getBusinessPrimaryKey());
        ArrayList<CallSite> foreignKeys = new ArrayList<CallSite>();
        for (E10Column column : table.getColumns()) {
            if (null == column.getLogicalFk()) continue;
            String fk = table.getTableName() + "." + column.getName() + "=" + column.getLogicalFk().getTableName() + "." + column.getLogicalFk().getColumnName();
            foreignKeys.add((CallSite)((Object)fk));
        }
        tableInfo.setForeignKey(String.join((CharSequence)"\u3001", foreignKeys));
        return tableInfo;
    }

    private List<ColumnInfo> toColumns(String agent, E10Table table) {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        for (E10Column column : table.getColumns()) {
            ColumnInfo info = new ColumnInfo();
            Object desc = column.getDescription();
            if (CollectionUtils.isNotEmpty(column.getDicPropertyList())) {
                StringBuilder sblist = new StringBuilder();
                sblist.append(System.lineSeparator()).append("\u652f\u6301\u8303\u56f4:").append(System.lineSeparator());
                for (E10DicProperty property : column.getDicPropertyList()) {
                    sblist.append("").append(property.getId()).append(":").append(property.getDisplayName()).append(",");
                }
                desc = (String)desc + sblist.toString();
            }
            info.setAgent(agent);
            info.setType("column");
            info.setTableName(table.getTableName());
            info.setCode(column.getName());
            info.setName(column.getDescription());
            info.setDescription((String)desc);
            info.setDbType(column.getDbType());
            if (null != column.getLogicalFk()) {
                info.setForeignKey(column.getLogicalFk().getTableName() + "." + column.getLogicalFk().getColumnName());
            }
            list.add(info);
        }
        return list;
    }

    public static PromptTemplate tableDesc() {
        return new PromptTemplate(ClassPathPromptLoader.loadPrompt((String)"tableDesc"));
    }
}

