/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.config;

import com.digiwin.athenai.prop.AiComponentProperties;
import com.knuddels.jtokkit.api.EncodingType;
import javax.sql.DataSource;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.SimpleLoggerAdvisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.memory.MessageWindowChatMemory;
import org.springframework.ai.chat.memory.repository.jdbc.JdbcChatMemoryRepository;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CompAiConfiguration {
    @Autowired
    AiComponentProperties aiComponentProperties;

    @Bean
    public ChatClient defaultChatClient(ChatModel chatModel) {
        return ChatClient.create((ChatModel)chatModel);
    }

    @Bean
    public ChatMemoryRepository aiDefaultChatRepository(DataSource dataSource) {
        JdbcChatMemoryRepository chatMemoryRepository = JdbcChatMemoryRepository.builder().dataSource(dataSource).build();
        return chatMemoryRepository;
    }

    @Bean
    public ChatMemory aiDefaultChatMemory(ChatMemoryRepository chatMemoryRepository) {
        MessageWindowChatMemory chatMemory = MessageWindowChatMemory.builder().chatMemoryRepository(chatMemoryRepository).maxMessages(this.aiComponentProperties.getDefaultChatMemorySize()).build();
        return chatMemory;
    }

    @Bean
    public MessageChatMemoryAdvisor aiDefaultMessageChatMemoryAdvisor(ChatMemory sqLiteChatMemory) {
        return MessageChatMemoryAdvisor.builder((ChatMemory)sqLiteChatMemory).build();
    }

    @Bean
    public SimpleLoggerAdvisor aiDefaultSimpleLoggerAdvisor() {
        return SimpleLoggerAdvisor.builder().build();
    }

    @Bean
    BatchingStrategy componentCountBatchingStrategy() {
        TokenCountBatchingStrategy strategy = new TokenCountBatchingStrategy(EncodingType.CL100K_BASE, 81910, 0.1);
        return strategy;
    }
}

