/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.controller;

import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.domain.AiRequest;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.tool.TimeTool;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"testcomp"})
public class TestComponentController {
    @Autowired
    AiChatService aiChatService;
    @Autowired
    AiEmbeddingService aiEmbeddingService;
    String agent = "agent01";
    @Autowired
    TimeTool componentTimeTool;
    @Autowired
    @Qualifier(value="loadbalancedMcpSyncToolCallbacks")
    ToolCallbackProvider tools;
    @Autowired
    EmbeddingModel embeddingModel;

    @RequestMapping(value={"test"})
    @GetMapping
    public Object test(@RequestBody AiRequest request) {
        String obj = "ok";
        return obj;
    }

    @RequestMapping(value={"test01"})
    @GetMapping
    public Object test01(@RequestParam(value="query", defaultValue="Tell me a joke") String query) {
        String obj = "ok";
        obj = this.aiChatService.simpleCall(query);
        return obj;
    }

    @GetMapping(value={"test02"}, produces={"text/event-stream"})
    public Flux<String> test02(@RequestParam(value="query", defaultValue="\u4f60\u597d\uff0c\u5f88\u9ad8\u5174\u8ba4\u8bc6\u4f60\uff0c\u80fd\u7b80\u5355\u4ecb\u7ecd\u4e00\u4e0b\u81ea\u5df1\u5417\uff1f") String query, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        return this.aiChatService.callStreamContent(AiRequest.create(query));
    }

    @RequestMapping(value={"addKnowledge"})
    @GetMapping
    public Object addKnowledge(@RequestParam(value="query", defaultValue="Tell me a joke") String query) {
        String obj = "ok";
        KnowledgeBase kb = new KnowledgeBase();
        kb.setCode(UUID.randomUUID().toString());
        kb.setDescription(query);
        kb.setType("table");
        kb.setName("\u5e93\u5b58\u8868");
        kb.setDescription("### \u5e93\u5b58\u8868\n* \u6a21\u578bcode\uff1ainventories_oms\n* \u6a21\u578b\u540d\u79f0\uff1a\u5e93\u5b58\u8868\n* \u529f\u80fd\uff1a\n#### \u6a21\u578b\u5b9a\u4e49\n| \u5b57\u6bb5ID |\u5b57\u6bb5\u663e\u793a\u540d\u79f0| \u6570\u636e\u7c7b\u578b | \u5b57\u6bb5\u957f\u5ea6 | \u5fc5\u586b | \u552f\u4e00 | \u4e3b\u952e | \u81ea\u589e | \u9ed8\u8ba4\u503c | \u5173\u8054\u4fe1\u606f | \u5b57\u5178\u5185\u5bb9/\u679a\u4e3e | \u8bf4\u660e |\n|--------|----------|----------|----------|------|------|------|------|--------|----------|----------|------|\n| inventories_oms_id | inventories\u4e3b\u952e | BIGINT | 20 | \u662f | \u662f | \u662f | \u662f |  |  |  | \u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u4e3b\u952e\u6807\u8bc6\uff0c\u7528\u4e8e\u552f\u4e00\u6807\u8bc6\u5e93\u5b58\u8bb0\u5f55 |\n| inventory_id | \u5e93\u5b58\u7f16\u53f7 | VARCHAR | 100 | \u662f | \u662f | \u5426 | \u5426 |  |  |  | \u5e93\u5b58\u8bb0\u5f55\u7684\u552f\u4e00\u6807\u8bc6\u7f16\u53f7\uff0c\u7528\u4e8e\u533a\u5206\u4e0d\u540c\u5e93\u5b58\u8bb0\u5f55 |\n| current_stock | \u5b9e\u9645\u5e93\u5b58\u91cf | INT | 11 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u5f53\u524d\u5b9e\u9645\u53ef\u7528\u7684\u5e93\u5b58\u6570\u91cf |\n| locked_stock | \u88ab\u9501\u5b9a\u5e93\u5b58 | INT | 11 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u5df2\u88ab\u8ba2\u5355\u9501\u5b9a\u3001\u6682\u4e0d\u53ef\u7528\u7684\u5e93\u5b58\u6570\u91cf |\n| in_transit_stock | \u5728\u9014\u5e93\u5b58 | INT | 11 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u6b63\u5728\u8fd0\u8f93\u9014\u4e2d\u3001\u5c1a\u672a\u5230\u8fbe\u7684\u5e93\u5b58\u6570\u91cf |\n| safety_stock | \u6700\u4f4e\u5e93\u5b58\u91cf | INT | 11 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u5b89\u5168\u5e93\u5b58\u9608\u503c\uff0c\u4f4e\u4e8e\u6b64\u6570\u91cf\u9700\u8981\u8865\u8d27 |\n| product_id | \u4ea7\u54c1\u7f16\u53f7 | VARCHAR | 100 | \u5426 | \u5426 | \u5426 | \u5426 |  | \u5173\u8054\u8868\uff1aproduct_table_oms.product_id |  | \u5916\u952e\u3002\u5173\u8054\u5230\u4ea7\u54c1\u8868\u7684\u4ea7\u54c1ID\uff0c\u6807\u8bc6\u5e93\u5b58\u5bf9\u5e94\u7684\u4ea7\u54c1 |\n| warehouse_id | \u4ed3\u5e93\u7f16\u53f7 | VARCHAR | 100 | \u5426 | \u5426 | \u5426 | \u5426 |  | \u5173\u8054\u8868\uff1awarehouse_table_oms.warehouse_id |  | \u5916\u952e\u3002\u5173\u8054\u5230\u4ed3\u5e93\u8868\u7684\u4ed3\u5e93ID\uff0c\u6807\u8bc6\u5e93\u5b58\u6240\u5728\u7684\u4ed3\u5e93\u4f4d\u7f6e |\n| tenantsid | \u79df\u6237sid | BIGINT | 20 | \u662f | \u5426 | \u5426 | \u5426 |  |  |  | \u7cfb\u7edf\u79df\u6237\u6807\u8bc6\uff0c\u7528\u4e8e\u591a\u79df\u6237\u7cfb\u7edf\u6570\u636e\u9694\u79bb |\n| tenant_id | \u79df\u6237Id | VARCHAR | 50 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u79df\u6237\u7684\u552f\u4e00\u6807\u8bc6\u7f16\u53f7 |\n| create_by | \u521b\u5efa\u8005 | VARCHAR | 50 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u8bb0\u5f55\u521b\u5efa\u8005\u7684\u6807\u8bc6\u4fe1\u606f |\n| create_date | \u521b\u5efa\u65f6\u95f4 | DATETIME |  | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u8bb0\u5f55\u7684\u521b\u5efa\u65f6\u95f4\u6233 |\n| modified_by | \u4fee\u6539\u8005 | VARCHAR | 50 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u6700\u540e\u4fee\u6539\u8bb0\u5f55\u7684\u64cd\u4f5c\u7528\u6237\u6807\u8bc6 |\n| modified_date | \u4fee\u6539\u65f6\u95f4 | DATETIME |  | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u8bb0\u5f55\u7684\u6700\u540e\u4fee\u6539\u65f6\u95f4\u6233 |\n| creator_name | \u521b\u5efa\u8005\u540d\u79f0 | VARCHAR | 40 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u521b\u5efa\u8005\u7684\u663e\u793a\u540d\u79f0 |\n| modifier_name | \u4fee\u6539\u8005\u540d\u79f0 | VARCHAR | 40 | \u5426 | \u5426 | \u5426 | \u5426 |  |  |  | \u6700\u540e\u4fee\u6539\u8005\u7684\u663e\u793a\u540d\u79f0 |\n");
        this.aiEmbeddingService.addKnowledge(this.agent, List.of(kb));
        return obj;
    }

    @RequestMapping(value={"searchKnowledge"})
    @GetMapping
    public Object searchKnowledge(@RequestParam(value="query", defaultValue="Tell me a joke") String query) {
        return this.aiEmbeddingService.searchDocuments(this.agent, query);
    }
}

