/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.utils;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioSpeechApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioTranscriptionApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeImageApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeVideoApi;
import com.digiwin.athenai.domain.DashScopeModel;
import com.digiwin.athenai.domain.DashScopeModels;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ModelsUtils {
    private static final String MODELS_FILE_PATH = "models.yaml";
    private static final String MODEL = "model";
    private static final String DESC = "desc";
    DashScopeApi.ChatModel chatModel;
    DashScopeApi.EmbeddingModel embeddingModel;
    DashScopeImageApi.ImageModel imageModel;
    DashScopeAudioSpeechApi.AudioSpeechModel audioSpeechModela;
    DashScopeAudioTranscriptionApi.AudioTranscriptionModel audioTranscriptionModel;
    DashScopeVideoApi.VideoModel videoModel;

    public static Set<Map<String, String>> getDashScopeModels() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        InputStream resourceAsStream = ModelsUtils.class.getClassLoader().getResourceAsStream(MODELS_FILE_PATH);
        DashScopeModels models = (DashScopeModels)mapper.readValue(resourceAsStream, DashScopeModels.class);
        HashSet<Map<String, String>> resultSet = new HashSet<Map<String, String>>();
        for (DashScopeModel model : models.getDashScope()) {
            HashMap<String, String> modelMap = new HashMap<String, String>();
            modelMap.put(MODEL, model.getName());
            modelMap.put(DESC, model.getDescription());
            resultSet.add(modelMap);
        }
        return resultSet;
    }
}

