/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.utils;

import com.digiwin.athenai.constant.Prompts;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.document.Document;
import org.springframework.util.CollectionUtils;

public class PromptUtil {
    private static final Function<List<Document>, String> DOCUMENTS_FORMATTER = documents -> documents.stream().map(Document::getText).collect(Collectors.joining(System.lineSeparator()));

    public static String formatConversationHistory(List<Message> history) {
        if (CollectionUtils.isEmpty(history)) {
            return "";
        }
        return history.stream().filter(message -> message.getMessageType().equals((Object)MessageType.USER) || message.getMessageType().equals((Object)MessageType.ASSISTANT)).map(message -> "%s: %s".formatted(message.getMessageType(), message.getText())).collect(Collectors.joining("\n"));
    }

    public static String concatMessages(List<String> history) {
        if (CollectionUtils.isEmpty(history)) {
            return "";
        }
        return history.stream().collect(Collectors.joining("\n"));
    }

    public static String formatDocuments(List<Document> documents) {
        if (CollectionUtils.isEmpty(documents)) {
            return "";
        }
        return DOCUMENTS_FORMATTER.apply(documents);
    }

    public static String contextQuery(String query, List<Document> documents) {
        if (CollectionUtils.isEmpty(documents)) {
            return query;
        }
        String context = PromptUtil.formatDocuments(documents);
        Map<String, String> promptParameters = Map.of("query", query, "context", context);
        return Prompts.CONTEXT_QUERY_PROMPT_TEMPLATE.render(promptParameters);
    }
}

