/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.advisor;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.chat.client.ChatClientMessageAggregator;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.client.advisor.api.BaseChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class HalfMessageChatMemoryAdvisor
implements BaseChatMemoryAdvisor {
    private ChatMemory chatMemory;
    private String defaultConversationId;
    private int order;
    private Scheduler scheduler;
    private boolean logBefore = true;
    private boolean logAfter = true;
    private boolean useHis = true;

    private HalfMessageChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int order, Scheduler scheduler, boolean logBefore, boolean logAfter, boolean useHis) {
        Assert.notNull((Object)chatMemory, (String)"chatMemory cannot be null");
        Assert.hasText((String)defaultConversationId, (String)"defaultConversationId cannot be null or empty");
        Assert.notNull((Object)scheduler, (String)"scheduler cannot be null");
        this.chatMemory = chatMemory;
        this.defaultConversationId = defaultConversationId;
        this.order = order;
        this.scheduler = scheduler;
        this.logBefore = logBefore;
        this.logAfter = logAfter;
        this.useHis = useHis;
    }

    public int getOrder() {
        return this.order;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        ChatClientRequest processedChatClientRequest = chatClientRequest;
        String conversationId = this.getConversationId(chatClientRequest.context(), this.defaultConversationId);
        if (this.useHis) {
            List memoryMessages = this.chatMemory.get(conversationId);
            ArrayList processedMessages = new ArrayList(memoryMessages);
            processedMessages.addAll(chatClientRequest.prompt().getInstructions());
            processedChatClientRequest = chatClientRequest.mutate().prompt(chatClientRequest.prompt().mutate().messages(processedMessages).build()).build();
        }
        if (this.logBefore) {
            UserMessage userMessage = processedChatClientRequest.prompt().getUserMessage();
            this.chatMemory.add(conversationId, (Message)userMessage);
        }
        return processedChatClientRequest;
    }

    public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        if (!this.logAfter) {
            return chatClientResponse;
        }
        List<Object> assistantMessages = new ArrayList();
        if (chatClientResponse.chatResponse() != null) {
            assistantMessages = chatClientResponse.chatResponse().getResults().stream().map(g -> g.getOutput()).toList();
        }
        this.chatMemory.add(this.getConversationId(chatClientResponse.context(), this.defaultConversationId), assistantMessages);
        return chatClientResponse;
    }

    public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAdvisorChain streamAdvisorChain) {
        Scheduler scheduler = this.getScheduler();
        return Mono.just((Object)chatClientRequest).publishOn(scheduler).map(request -> this.before((ChatClientRequest)request, (AdvisorChain)streamAdvisorChain)).flatMapMany(arg_0 -> ((StreamAdvisorChain)streamAdvisorChain).nextStream(arg_0)).transform(flux -> new ChatClientMessageAggregator().aggregateChatClientResponse(flux, response -> this.after((ChatClientResponse)response, (AdvisorChain)streamAdvisorChain)));
    }

    public static Builder builder(ChatMemory chatMemory) {
        return new Builder(chatMemory);
    }

    public static final class Builder {
        private String conversationId = "default";
        private int order = -2147482648;
        private Scheduler scheduler = BaseAdvisor.DEFAULT_SCHEDULER;
        private ChatMemory chatMemory;
        private boolean logBefore = true;
        private boolean logAfter = true;
        private boolean useHis = true;

        private Builder(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder logBefore(boolean logBefore) {
            this.logBefore = logBefore;
            return this;
        }

        public Builder logAfter(boolean logAfter) {
            this.logAfter = logAfter;
            return this;
        }

        public Builder userHis(boolean useHis) {
            this.useHis = useHis;
            return this;
        }

        public HalfMessageChatMemoryAdvisor build() {
            return new HalfMessageChatMemoryAdvisor(this.chatMemory, this.conversationId, this.order, this.scheduler, this.logBefore, this.logAfter, this.useHis);
        }
    }
}

