/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.advisor;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.util.StringUtils;

public class ReasoningContentAdvisor
implements BaseAdvisor {
    private final int order;

    public ReasoningContentAdvisor(Integer order) {
        this.order = order != null ? order : 0;
    }

    public int getOrder() {
        return this.order;
    }

    public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        return chatClientRequest;
    }

    public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        ChatResponse resp = chatClientResponse.chatResponse();
        if (Objects.isNull(resp)) {
            return chatClientResponse;
        }
        String reasoningContent = String.valueOf(((Generation)resp.getResults().get(0)).getOutput().getMetadata().get("reasoningContent"));
        if (StringUtils.hasText((String)reasoningContent)) {
            List<Generation> thinkGenerations = resp.getResults().stream().map(generation -> {
                AssistantMessage output = generation.getOutput();
                AssistantMessage thinkAssistantMessage = new AssistantMessage(String.format("<think>%s</think>", reasoningContent) + output.getText(), output.getMetadata(), output.getToolCalls(), output.getMedia());
                return new Generation(thinkAssistantMessage, generation.getMetadata());
            }).toList();
            ChatResponse thinkChatResp = ChatResponse.builder().from(resp).generations(thinkGenerations).build();
            return ChatClientResponse.builder().context(chatClientResponse.context()).chatResponse(thinkChatResp).build();
        }
        return chatClientResponse;
    }
}

