/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.advisor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.metadata.Usage;

public class TokenCounterAdvisor
implements BaseAdvisor {
    public static Map<String, AtomicLong> modelInput = new HashMap<String, AtomicLong>();
    public static Map<String, AtomicLong> modelOutput = new HashMap<String, AtomicLong>();

    public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        return chatClientRequest;
    }

    public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        String model = chatClientResponse.chatResponse().getMetadata().getModel();
        AtomicLong input = modelInput.get(model);
        AtomicLong output = modelOutput.get(model);
        if (null == input) {
            input = new AtomicLong();
            modelInput.put(model, input);
        }
        if (null == output) {
            output = new AtomicLong();
            modelOutput.put(model, output);
        }
        try {
            Usage usage = chatClientResponse.chatResponse().getMetadata().getUsage();
            if (null != usage) {
                Integer inputCount = usage.getPromptTokens();
                Integer outputCount = usage.getCompletionTokens();
                input.addAndGet(inputCount.intValue());
                output.addAndGet(outputCount.intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chatClientResponse;
    }

    public int getOrder() {
        return 0;
    }
}

