/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.component;

import com.digiwin.athenai.component.AiComponentManager;
import com.digiwin.athenai.component.service.AiModelService;
import com.digiwin.athenai.prop.AiComponentProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.image.ImageModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class AiComponentConfiguration {
    @Autowired
    AiComponentProperties aiComponentProperties;
    @Autowired
    AiComponentManager aiComponentManager;

    @Primary
    @Bean
    public ChatModel primaryChatModel() {
        AiModelService modelService;
        ChatModel chatModel = this.aiComponentManager.defaultAiModelService().chatModel();
        if (StringUtils.isNotEmpty((CharSequence)this.aiComponentProperties.getModelPlatform().getChat()) && null != (modelService = this.aiComponentManager.aiModelService(this.aiComponentProperties.getModelPlatform().getChat())) && null != modelService.chatModel()) {
            chatModel = modelService.chatModel();
        }
        return chatModel;
    }

    @Primary
    @Bean
    public EmbeddingModel primaryEmbeddingModel() {
        AiModelService modelService;
        EmbeddingModel embeddingModel = this.aiComponentManager.defaultAiModelService().embeddingModel();
        if (StringUtils.isNotEmpty((CharSequence)this.aiComponentProperties.getModelPlatform().getEmbedding()) && null != (modelService = this.aiComponentManager.aiModelService(this.aiComponentProperties.getModelPlatform().getEmbedding())) && null != modelService.embeddingModel()) {
            embeddingModel = modelService.embeddingModel();
        }
        if (null == embeddingModel) {
            for (AiModelService modelService2 : this.aiComponentManager.aiModelServices()) {
                if (null == modelService2.embeddingModel()) continue;
                return modelService2.embeddingModel();
            }
        }
        return embeddingModel;
    }

    @Primary
    @Bean
    public ImageModel primaryImageModel() {
        AiModelService modelService;
        ImageModel imageModel = this.aiComponentManager.defaultAiModelService().imageModel();
        if (StringUtils.isNotEmpty((CharSequence)this.aiComponentProperties.getModelPlatform().getImage()) && null != (modelService = this.aiComponentManager.aiModelService(this.aiComponentProperties.getModelPlatform().getImage())) && null != modelService.imageModel()) {
            imageModel = modelService.imageModel();
        }
        if (null == imageModel) {
            for (AiModelService modelService2 : this.aiComponentManager.aiModelServices()) {
                if (null == modelService2.imageModel()) continue;
                return modelService2.imageModel();
            }
        }
        return imageModel;
    }

    @Primary
    @Bean
    public RestClient primaryRestClient() {
        return this.aiComponentManager.defaultAiModelService().restClient();
    }

    @Primary
    @Bean
    public WebClient primaryWebClient() {
        return this.aiComponentManager.defaultAiModelService().webClient();
    }
}

