/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.component;

import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.constant.Prompts;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PromptAsistant {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PromptAsistant.class);
    @Autowired
    @Lazy
    private AiChatService aiChatService;

    public String rewriteQueryForVectorSearch(String query) {
        String rewrittenQueryText = this.aiChatService.chatClient().prompt().user(user -> user.text(Prompts.REWRITE_PROMPT_TEMPLATE.getTemplate()).param("query", (Object)query)).call().content();
        log.info("rewrite query: {} => {}", (Object)query, (Object)rewrittenQueryText);
        return rewrittenQueryText;
    }

    public List<String> expandMultiQuery(String query, int numberOfQueries) {
        String response = this.aiChatService.chatClient().prompt().user(user -> user.text(Prompts.EXPAND_PROMPT_TEMPLATE.getTemplate()).param("number", (Object)numberOfQueries).param("query", (Object)query)).call().content();
        if (response == null) {
            log.warn("Query expansion result is null. Returning the input query unchanged.");
            return List.of(query);
        }
        List<String> queryVariants = Arrays.asList(response.split("\n"));
        log.info("expandMulti query: {} => {}", (Object)query, Arrays.asList(queryVariants));
        return queryVariants;
    }

    public List<String> text2keywords(String query) {
        String response = this.process(Prompts.question_keywords_template, Map.of("question", query));
        List keywords = (List)new Gson().fromJson(response, new TypeToken<List<String>>(this){}.getType());
        log.info("text2keywords : {} => {}", (Object)query, (Object)keywords);
        return keywords;
    }

    public String process(PromptTemplate template, Map<String, Object> variables) {
        return this.aiChatService.chatClient().prompt().user(user -> user.text(template.getTemplate()).params(variables)).call().content();
    }
}

