/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.component.impl;

import com.digiwin.athenai.component.service.AiModelService;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

public abstract class AbstractAiModelService
implements AiModelService {
    @Autowired
    RestClient.Builder restClientBuilder;
    @Autowired
    WebClient.Builder webClientBuilder;
    @Autowired
    ResponseErrorHandler responseErrorHandler;

    @Override
    public RestClient restClient() {
        Consumer<HttpHeaders> finalHeaders = h -> {
            h.setBearerAuth(this.getApiKey());
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        RestClient restClient = this.restClientBuilder.clone().baseUrl(this.getBaseUrl()).defaultHeaders(finalHeaders).defaultStatusHandler(this.responseErrorHandler).build();
        return restClient;
    }

    @Override
    public WebClient webClient() {
        Consumer<HttpHeaders> finalHeaders = h -> {
            h.setBearerAuth(this.getApiKey());
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        WebClient restClient = this.webClientBuilder.clone().baseUrl(this.getBaseUrl()).defaultHeaders(finalHeaders).build();
        return restClient;
    }

    public abstract String getBaseUrl();

    public abstract String getApiKey();
}

