/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athenai.domain.ParamBean;
import com.digiwin.athenai.domain.ResultBean;
import io.micrometer.common.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AbstractBasicService<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T> {
    public ResultBean saveEntity(T info) {
        this.saveOrUpdate(info);
        return ResultBean.success(info);
    }

    public ResultBean delete(Long id) {
        Boolean r = this.removeById(id);
        return ResultBean.success(r);
    }

    public ResultBean deleteBatch(List<Long> ids) {
        Boolean r = this.removeBatchByIds(ids);
        return ResultBean.success(r);
    }

    public ResultBean get(Long id) {
        Object info = this.getById(id);
        return ResultBean.success(info);
    }

    public ResultBean query(ParamBean<T> paramBean) {
        QueryWrapper queryWrapper = this.queryWrapper(paramBean);
        ResultBean resultBean = this.select(paramBean, queryWrapper);
        return resultBean;
    }

    public ResultBean queryByMap(ParamBean<Map<String, Object>> paramBean) {
        QueryWrapper queryWrapper = this.queryWrapperMap(paramBean);
        ResultBean resultBean = this.select(paramBean, queryWrapper);
        return resultBean;
    }

    protected ResultBean select(ParamBean paramBean, QueryWrapper queryWrapper) {
        ResultBean<List> resultBean = new ResultBean<List>();
        if (StringUtils.isNotEmpty((String)paramBean.getSortField())) {
            if ("descending".equalsIgnoreCase(paramBean.getSortType()) || "desc".equalsIgnoreCase(paramBean.getSortType())) {
                queryWrapper.orderByDesc((Object)paramBean.getSortField());
            } else {
                queryWrapper.orderByAsc((Object)paramBean.getSortField());
            }
        }
        Page pages = (Page)this.page((IPage)Page.of((long)paramBean.getPageIndex().intValue(), (long)paramBean.getPageSize().intValue()), (Wrapper)queryWrapper);
        resultBean.setData(pages.getRecords());
        resultBean.setTotalCount(pages.getTotal());
        resultBean.setPageSize(pages.getSize());
        resultBean.setPageIndex(pages.getCurrent());
        return resultBean;
    }

    protected QueryWrapper queryWrapper(ParamBean<T> paramBean) {
        QueryWrapper queryWrapper = new QueryWrapper(paramBean.getValue());
        return queryWrapper;
    }

    protected QueryWrapper queryWrapperMap(ParamBean<Map<String, Object>> paramBean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        for (Map.Entry<String, Object> entry : paramBean.getValue().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (null == value || value instanceof String && StringUtils.isEmpty((String)((String)value))) continue;
            if (value instanceof Collection) {
                queryWrapper.in((Object)key, new Object[]{value});
                continue;
            }
            queryWrapper.eq((Object)key, value);
        }
        return queryWrapper;
    }
}

