/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.tool;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Component;

@Component
public class TimeTool {
    Logger logger = LoggerFactory.getLogger(TimeTool.class);

    @Tool(description="Get the time of a specified city.")
    public String getCityTimeMethod(@ToolParam(description="Time zone id, such as Asia/Shanghai") String timeZoneId) {
        this.logger.info("The current time zone is {}", (Object)timeZoneId);
        return String.format("The current time zone is %s and the current time is %s", timeZoneId, this.getTimeByZoneId(timeZoneId));
    }

    private String getTimeByZoneId(String zoneId) {
        ZoneId zid = ZoneId.of(zoneId);
        ZonedDateTime zonedDateTime = ZonedDateTime.now(zid);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
        String formattedDateTime = zonedDateTime.format(formatter);
        return formattedDateTime;
    }
}

