/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.utils;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athenai.domain.AiMedia;
import com.digiwin.athenai.domain.AiMessage;
import com.digiwin.athenai.domain.AiOptions;
import com.digiwin.athenai.domain.AiRequest;
import com.digiwin.athenai.domain.AiSearchRequest;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.model.Plan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.DefaultChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.content.Media;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class AiBeanConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiBeanConverter.class);
    private static final Function<List<Document>, String> DEFAULT_DOCUMENT_FORMATTER = documents -> documents.stream().map(Document::getText).collect(Collectors.joining(System.lineSeparator()));
    private static Function<ChatResponse, String> contentExtractor = response -> response.getResult().getOutput().getText();

    public static ChatOptions convertChatOptions(AiOptions options) {
        if (options == null) {
            return null;
        }
        DefaultChatOptions defaultOptions = new DefaultChatOptions();
        BeanUtils.copyProperties((Object)options, (Object)defaultOptions);
        return defaultOptions;
    }

    public static Media convertMedia(AiMedia media) {
        if (media == null) {
            return null;
        }
        return Media.builder().id(media.getId()).name(media.getName()).mimeType(media.getMimeType()).data(media.getData()).build();
    }

    public static List<Media> convertMedia(List<AiMedia> media) {
        ArrayList<Media> result = new ArrayList<Media>();
        if (null != media) {
            for (AiMedia m : media) {
                result.add(AiBeanConverter.convertMedia(m));
            }
        }
        return result;
    }

    public static Message convertMessage(AiMessage message) {
        if (message == null) {
            return null;
        }
        UserMessage userMessage = UserMessage.builder().media(AiBeanConverter.convertMedia(message.getMedia())).text(message.getText()).metadata(message.getMetadata()).build();
        return userMessage;
    }

    public static List<Message> convertMessage(List<AiMessage> messages) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (null != messages) {
            for (AiMessage m : messages) {
                result.add(AiBeanConverter.convertMessage(m));
            }
        }
        return result;
    }

    public static Prompt convertPrompt(AiRequest prompt) {
        if (prompt == null) {
            return null;
        }
        Prompt result = null;
        if (CollectionUtils.isNotEmpty(prompt.getMessages())) {
            result = new Prompt(AiBeanConverter.convertMessage(prompt.getMessages()), AiBeanConverter.convertChatOptions(prompt.getChatOptions()));
        } else {
            ArrayList<Object> messages = new ArrayList<Object>();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)prompt.getSystem())) {
                messages.add(new SystemMessage(AiBeanConverter.renderText(prompt.getText(), prompt.getParams())));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)prompt.getText())) {
                messages.add(new UserMessage(AiBeanConverter.renderText(prompt.getText(), prompt.getParams())));
            }
            result = new Prompt(messages, AiBeanConverter.convertChatOptions(prompt.getChatOptions()));
        }
        return result;
    }

    public static Document knowledge2Doc(KnowledgeBase knowledge, Map<String, Object> meta) {
        String prompt;
        if (null == meta) {
            meta = new HashMap<String, Object>();
        }
        if (!StringUtils.hasText((String)(prompt = knowledge.getPrompt()))) {
            prompt = knowledge.getDescription();
        }
        if (!StringUtils.hasText((String)prompt)) {
            prompt = knowledge.getName();
        }
        if (!StringUtils.hasText((String)prompt)) {
            throw new IllegalArgumentException("prompt is null");
        }
        if (null == meta.get("code")) {
            meta.put("code", knowledge.getCode());
        }
        if (null == meta.get("type")) {
            meta.put("type", knowledge.getType());
        }
        if (null == meta.get("name")) {
            meta.put("name", knowledge.getName());
        }
        if (null == meta.get("category")) {
            meta.put("category", knowledge.getCategory());
        }
        if (null == meta.get("vectorType")) {
            meta.put("vectorType", knowledge.getVectorType());
        }
        meta.entrySet().removeIf(entry -> entry.getValue() == null);
        return Document.builder().id(knowledge.getVectorId()).text(prompt).metadata(meta).build();
    }

    public static List<Document> knowledge2Doc(List<? extends KnowledgeBase> knowledges, Map<String, Object> param) {
        ArrayList<Document> result = new ArrayList<Document>();
        if (null != knowledges) {
            for (KnowledgeBase knowledgeBase : knowledges) {
                if (null == knowledgeBase.getVectorId()) {
                    knowledgeBase.setVectorId(UUID.randomUUID().toString());
                }
                try {
                    result.add(AiBeanConverter.knowledge2Doc(knowledgeBase, param));
                }
                catch (Exception e) {
                    log.error("ignore error knowledge:" + JSON.toJSONString((Object)knowledgeBase));
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String renderText(String text, Map<String, Object> param) {
        String result = text;
        if (CollectionUtils.isNotEmpty(param) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)text)) {
            PromptTemplate promptTemplate = new PromptTemplate(text);
            result = promptTemplate.render(param);
        }
        return result;
    }

    public static String getContentFromChatResponse(@Nullable ChatResponse chatResponse) {
        return Optional.ofNullable(chatResponse).map(ChatResponse::getResult).map(Generation::getOutput).map(AbstractMessage::getText).orElse(null);
    }

    public static Flux<String> getContentFromChatResponse(Flux<ChatResponse> responseFlux) {
        if (null == responseFlux) {
            return null;
        }
        return responseFlux.map(r -> {
            if (r.getResult() == null || r.getResult().getOutput() == null || r.getResult().getOutput().getText() == null) {
                return "";
            }
            return r.getResult().getOutput().getText();
        }).filter(StringUtils::hasLength);
    }

    public static SearchRequest convertSearchRequest(AiSearchRequest request) {
        if (null == request) {
            return null;
        }
        SearchRequest.Builder builder = SearchRequest.builder();
        if (null != request.getQuery()) {
            builder.query(request.getQuery());
        }
        if (null != request.getFilterExpression()) {
            builder.filterExpression(request.getFilterExpression());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getVectorType())) {
            FilterExpressionBuilder b = new FilterExpressionBuilder();
            Filter.Expression expression = b.eq("vectorType", (Object)request.getVectorType()).build();
            builder.filterExpression(expression);
        }
        builder.similarityThreshold(request.getSimilarityThreshold());
        builder.topK(request.getTopK());
        return builder.build();
    }

    public static String joinDocuments(List<Document> documents) {
        return DEFAULT_DOCUMENT_FORMATTER.apply(documents);
    }

    public static String chatResponseContent(ChatResponse chatResponse) {
        return contentExtractor.apply(chatResponse);
    }

    public static Plan convertPlan(String text) {
        BeanOutputConverter converter = new BeanOutputConverter((ParameterizedTypeReference)new ParameterizedTypeReference<Plan>(){});
        return (Plan)converter.convert(text);
    }
}

