/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.component;

import com.digiwin.athenai.component.PromptAsistant;
import com.digiwin.athenai.domain.AiSearchRequest;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.utils.AiBeanConverter;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.ai.vectorstore.mariadb.MariaDBVectorStore;
import org.springframework.ai.vectorstore.mariadb.autoconfigure.MariaDbStoreProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AiEmbeddingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiEmbeddingService.class);
    private final Map<String, VectorStore> agentStores = new ConcurrentHashMap<String, VectorStore>();
    private final Executor taskExecutor = Executors.newCachedThreadPool();
    @Autowired
    private EmbeddingModel embeddingModel;
    @Autowired
    private VectorStore vectorStore;
    @Autowired
    @Resource(name="mariaDbJdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    BatchingStrategy batchingStrategy;
    @Autowired
    PromptAsistant promptAsistant;
    @Autowired
    MariaDbStoreProperties mariaDbStoreProperties;

    public EmbeddingResponse embedding(List<String> messages) {
        EmbeddingResponse embeddingResponse = this.embeddingModel.embedForResponse(messages);
        return embeddingResponse;
    }

    public EmbeddingResponse embedding(String message) {
        return this.embedding(List.of(message));
    }

    public void addDocuments(List<Document> documents) {
        this.vectorStore.add(documents);
    }

    public VectorStore getOrCreateVectorStore(String agent, MariaDbStoreProperties props) {
        VectorStore store = this.agentStores.computeIfAbsent(agent, id -> {
            MariaDbStoreProperties properties;
            Object table = "vector_store";
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                table = (String)table + "_" + id;
            }
            if ((properties = props) == null) {
                properties = this.mariaDbStoreProperties;
            }
            MariaDBVectorStore mariaDBVectorStore = ((MariaDBVectorStore.MariaDBBuilder)MariaDBVectorStore.builder((JdbcTemplate)this.jdbcTemplate, (EmbeddingModel)this.embeddingModel).schemaName(properties.getSchemaName()).vectorTableName((String)table).initializeSchema(true).batchingStrategy(this.batchingStrategy)).schemaName(properties.getSchemaName()).schemaValidation(properties.isSchemaValidation()).dimensions(properties.getDimensions()).distanceType(properties.getDistanceType()).contentFieldName(properties.getContentFieldName()).embeddingFieldName(properties.getEmbeddingFieldName()).idFieldName(properties.getIdFieldName()).metadataFieldName(properties.getMetadataFieldName()).removeExistingVectorStoreTable(properties.isRemoveExistingVectorStoreTable()).maxDocumentBatchSize(properties.getMaxDocumentBatchSize()).build();
            mariaDBVectorStore.afterPropertiesSet();
            return mariaDBVectorStore;
        });
        return store;
    }

    public void addDocuments(String agent, List<Document> documents) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        List ids = documents.stream().map(Document::getId).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ids)) {
            store.delete(ids);
        }
        store.add(documents);
    }

    public void addKnowledge(String agent, List<? extends KnowledgeBase> knowledges) {
        this.addDocuments(agent, AiBeanConverter.knowledge2Doc(knowledges, null));
    }

    public void addKnowledges(String agent, List<? extends KnowledgeBase> knowledges, Map<String, Object> meta) {
        this.addDocuments(agent, AiBeanConverter.knowledge2Doc(knowledges, meta));
    }

    public void addDocument(String agent, String text, Map<String, Object> meta) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        Document doc = Document.builder().text(text).metadata(meta).id(UUID.randomUUID().toString()).build();
        store.add(List.of(doc));
    }

    public void deleteDocuments(String agent, List<String> documents) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        store.delete(documents);
    }

    public void deleteDocuments(String agent, String expression) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        store.delete(expression);
    }

    public void deleteDocuments(String agent, Filter.Expression expression) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        store.delete(expression);
    }

    public void deleteDocumentByVectorType(String agent, String vectorType) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        try {
            FilterExpressionBuilder builder = new FilterExpressionBuilder();
            Filter.Expression expression = builder.eq("vectorType", (Object)vectorType).build();
            List documents = store.similaritySearch(SearchRequest.builder().query("").topK(Integer.MAX_VALUE).filterExpression(expression).build());
            if (!documents.isEmpty()) {
                List<String> documentIds = documents.stream().map(Document::getId).toList();
                store.delete(documentIds);
                log.info("Deleted {} documents of type '{}' for agent: {}", new Object[]{documents.size(), vectorType, agent});
            } else {
                log.info("No documents of type '{}' found for agent: {}", (Object)vectorType, (Object)agent);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete documents by type for agent: {}", (Object)agent, (Object)e);
            throw new RuntimeException("Failed to delete documents by type: " + e.getMessage(), e);
        }
    }

    public List<Document> searchDocuments(String agent, String query, String vectorType) {
        AiSearchRequest aiSearchRequest = new AiSearchRequest();
        aiSearchRequest.setAgent(agent);
        aiSearchRequest.setQuery(query);
        aiSearchRequest.setVectorType(vectorType);
        return this.searchDocuments(aiSearchRequest);
    }

    public List<Document> searchDocuments(String agent, String query) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        List documents = store.similaritySearch(query);
        return documents;
    }

    public List<Document> searchDocuments(AiSearchRequest request) {
        VectorStore store = this.getOrCreateVectorStore(request.getAgent(), null);
        List documents = store.similaritySearch(AiBeanConverter.convertSearchRequest(request));
        return documents;
    }

    public List<Document> expandSearchDocuments(AiSearchRequest request) {
        String query = request.getQuery();
        List<String> multilQuery = this.promptAsistant.expandMultiQuery(query, 3);
        List documentsForQuery = multilQuery.stream().map(q -> CompletableFuture.supplyAsync(() -> {
            AiSearchRequest newRequest = request.mutate();
            newRequest.setQuery((String)q);
            return this.searchDocuments(newRequest);
        }, this.taskExecutor)).toList().stream().map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        return documentsForQuery.stream().flatMap(Collection::stream).collect(Collectors.toMap(Document::getId, Function.identity(), (existing, duplicate) -> existing)).values().stream().sorted(Comparator.comparingDouble(doc -> doc.getScore() != null ? doc.getScore() : 0.0).reversed()).toList();
    }

    public VectorStore vectorStore(String agent) {
        VectorStore store = this.getOrCreateVectorStore(agent, null);
        return store;
    }
}

