/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.config;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class DataSourceConfig {
    @Primary
    @Bean(name={"mariaDbDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.mariadb")
    public DataSource mariaDbDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Primary
    @Bean(name={"mariaDbJdbcTemplate"})
    public JdbcTemplate mariaDbJdbcTemplate(@Qualifier(value="mariaDbDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }
}

