/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.domain.KnowledgeBase;
import com.digiwin.athenai.service.AbstractBasicService;
import com.digiwin.athenai.support.MyTokenTextSplitter;
import com.digiwin.athenai.utils.IdUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class AbstractKnowledgeBaseService<M extends BaseMapper<T>, T extends KnowledgeBase>
extends AbstractBasicService<M, T> {
    @Autowired
    AiEmbeddingService aiEmbeddingService;
    MyTokenTextSplitter myTokenTextSplitter = new MyTokenTextSplitter();

    public T findByAgentAndCode(String agent, String code) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"code", (Object)code)).eq((Object)"agent", (Object)agent);
        KnowledgeBase infoIndb = (KnowledgeBase)this.baseMapper.selectOne((Wrapper)wrapper);
        return (T)infoIndb;
    }

    @Transactional
    public T addKnowledge(String agent, T knowledge, Map<String, Object> meta) {
        Assert.notNull((Object)((KnowledgeBase)knowledge).getCode(), (String)"table code is null");
        Assert.notNull((Object)((KnowledgeBase)knowledge).getPrompt(), (String)"table prompt is null");
        ArrayList<String> vectors = new ArrayList<String>();
        ArrayList<KnowledgeBase> knowledgeBases = new ArrayList<KnowledgeBase>();
        String content = ((KnowledgeBase)knowledge).getPrompt();
        if (content.length() > MyTokenTextSplitter.chunkSize) {
            List<String> texts = this.myTokenTextSplitter.split(content);
            for (String t : texts) {
                KnowledgeBase knowledgeBase = this.tokb(knowledge, t);
                knowledgeBases.add(knowledgeBase);
                vectors.add(knowledgeBase.getVectorId());
            }
        } else {
            KnowledgeBase knowledgeBase = this.tokb(knowledge, ((KnowledgeBase)knowledge).getPrompt());
            knowledgeBases.add(knowledgeBase);
            vectors.add(knowledgeBase.getVectorId());
        }
        ((KnowledgeBase)knowledge).setVectorId(StringUtils.join(vectors, (String)","));
        this.deleteAgentKnowledge(agent, ((KnowledgeBase)knowledge).getCode());
        this.aiEmbeddingService.addKnowledges(agent, knowledgeBases, meta);
        this.baseMapper.insert(knowledge);
        return knowledge;
    }

    public Integer deleteAgentKnowledge(String agent, String code) {
        int delted = 0;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"code", (Object)code)).eq((Object)"agent", (Object)agent);
        KnowledgeBase infoIndb = (KnowledgeBase)this.baseMapper.selectOne((Wrapper)wrapper);
        if (null != infoIndb) {
            delted = this.baseMapper.deleteById((Serializable)infoIndb.getId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{infoIndb.getVectorId()})) {
                String[] ids = infoIndb.getVectorId().split(",");
                this.aiEmbeddingService.deleteDocuments(agent, Arrays.asList(ids));
            }
        }
        return delted;
    }

    public KnowledgeBase tokb(T tableInfo, String text) {
        KnowledgeBase base = new KnowledgeBase();
        base.setVectorId(IdUtil.uuid());
        base.setCode(((KnowledgeBase)tableInfo).getCode());
        base.setName(((KnowledgeBase)tableInfo).getName());
        base.setType(((KnowledgeBase)tableInfo).getType());
        base.setPrompt(text);
        return base;
    }
}

