/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.utils;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.springframework.ai.reader.JsonReader;
import org.springframework.ai.reader.TextReader;
import org.springframework.ai.reader.markdown.MarkdownDocumentReader;
import org.springframework.ai.reader.pdf.PagePdfDocumentReader;
import org.springframework.ai.reader.tika.TikaDocumentReader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DocumentReader {
    public static List<Document> readText(Resource resource) {
        TextReader textReader = new TextReader(resource);
        return textReader.read();
    }

    public static List<Document> readJson(Resource resource) {
        JsonReader textReader = new JsonReader(resource);
        return textReader.read();
    }

    public static List<Document> readHtml(Resource resource) {
        TextReader textReader = new TextReader(resource);
        return textReader.read();
    }

    public static List<Document> readPdf(Resource resource) {
        PagePdfDocumentReader textReader = new PagePdfDocumentReader(resource);
        return textReader.read();
    }

    public static List<Document> readmd(String resource) {
        MarkdownDocumentReader textReader = new MarkdownDocumentReader(resource);
        return textReader.read();
    }

    public static List<Document> readtika(Resource resource) {
        TikaDocumentReader textReader = new TikaDocumentReader(resource);
        return textReader.read();
    }

    public static Resource readFile(String filename) {
        return new DefaultResourceLoader().getResource(filename);
    }

    public static String readMultiFile(String url, MultipartFile file) {
        if (Objects.nonNull(file)) {
            List documents = new TikaDocumentReader(file.getResource()).get();
            return documents.stream().map(Document::getFormattedContent).collect(Collectors.joining("\n\n"));
        }
        if (StringUtils.hasText((String)url)) {
            List documents = new TikaDocumentReader(url).get();
            return documents.stream().map(Document::getFormattedContent).collect(Collectors.joining("\n\n"));
        }
        return "";
    }

    public static void main(String[] args) throws FileNotFoundException {
    }
}

