/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.utils;

import cn.hutool.core.io.resource.ResourceUtil;
import com.digiwin.athenai.exception.SAAAIException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FilesUtils {
    private static final Logger logger = LoggerFactory.getLogger(FilesUtils.class);
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Random RANDOM = new Random();

    private FilesUtils() {
    }

    private static String generateRandomFileName(String originalFilename) {
        String extension = "";
        int dotIndex = originalFilename.lastIndexOf(".");
        if (dotIndex > 0) {
            extension = originalFilename.substring(dotIndex);
        }
        return FilesUtils.generateRandomString() + extension;
    }

    private static String generateRandomString() {
        StringBuilder result = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            int index = RANDOM.nextInt(CHARACTERS.length());
            result.append(CHARACTERS.charAt(index));
        }
        return result.toString();
    }

    public static void initTmpFolder(String path) {
        if (path == null || path.isEmpty()) {
            throw new SAAAIException("path is null or empty");
        }
        File tmpFolder = new File(path);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        logger.info("Init tmp folder: {}", (Object)tmpFolder.getAbsolutePath());
    }

    public static void deleteDirectory(File directory) {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FilesUtils.deleteDirectory(file);
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    public static String saveTempFile(MultipartFile file, String path) throws IOException {
        if (file == null || file.isEmpty()) {
            throw new SAAAIException("File is null or empty");
        }
        String randomFileName = FilesUtils.generateRandomFileName(file.getOriginalFilename());
        String filePath = System.getProperty("user.dir") + path + randomFileName;
        file.transferTo(new File(filePath));
        return filePath;
    }

    public static String loadContent(String file) {
        String content = ResourceUtil.readStr((String)file, (Charset)Charset.defaultCharset());
        return content;
    }
}

