/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.common.agent.context;

import com.digiwin.athena.ai.generate.tools.common.agent.context.DialogueContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ai.chat.prompt.ChatOptions;

public class DialogueContextBuilder {
    private String prompt;
    private String model;
    private ChatOptions options;
    private Map<String, Object> parameters;

    public static DialogueContextBuilder create() {
        return new DialogueContextBuilder();
    }

    public DialogueContextBuilder withPrompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    public DialogueContextBuilder withModel(String model) {
        this.model = model;
        return this;
    }

    public DialogueContextBuilder withOptions(ChatOptions options) {
        this.options = options;
        return this;
    }

    public DialogueContextBuilder withParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, Object>();
        }
        this.parameters.put(key, value);
        return this;
    }

    public DialogueContext build() {
        return new DialogueContext(this.prompt, this.model, this.options, this.parameters);
    }
}

