/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.common.agent.service;

import com.digiwin.athena.ai.generate.tools.common.agent.context.DialogueContext;
import com.digiwin.athena.ai.generate.tools.common.agent.context.DialogueContextBuilder;
import com.digiwin.athena.ai.generate.tools.common.agent.processor.BatchCodeResponseProcessor;
import com.digiwin.athena.ai.generate.tools.common.agent.processor.JsonResponseProcessor;
import com.digiwin.athena.ai.generate.tools.common.agent.processor.ResponseProcessor;
import com.digiwin.athena.ai.generate.tools.common.agent.processor.StringResponseProcessor;
import com.digiwin.athena.ai.generate.tools.common.agent.service.IntelligentDialogueService;
import com.digiwin.athena.ai.generate.tools.exception.BusinessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public abstract class UniversalIntelligentDialogueService
implements IntelligentDialogueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UniversalIntelligentDialogueService.class);
    public static final String JSON = "json";
    public static final String STRING = "string";
    public static final String BATCH_PROCESSOR = "batch_json";
    protected final ChatClient intelligentDialogueClient;
    private final Map<String, ResponseProcessor<?>> responseProcessors;

    protected UniversalIntelligentDialogueService(ChatClient intelligentDialogueClient) {
        this.intelligentDialogueClient = intelligentDialogueClient;
        this.responseProcessors = new ConcurrentHashMap();
        this.initializeDefaultProcessors();
    }

    protected void initializeDefaultProcessors() {
        this.registerResponseProcessor(JSON, new JsonResponseProcessor());
        this.registerResponseProcessor(STRING, new StringResponseProcessor());
        this.registerResponseProcessor(BATCH_PROCESSOR, new BatchCodeResponseProcessor());
    }

    protected void registerResponseProcessor(String processorType, ResponseProcessor<?> processor) {
        this.responseProcessors.put(processorType, processor);
    }

    @Override
    public <T> T executeDialogue(String prompt, String model, ParameterizedTypeReference<T> responseType) {
        DialogueContext context = DialogueContextBuilder.create().withPrompt(prompt).withModel(model).build();
        return this.executeDialogue(context, responseType);
    }

    @Override
    public String executeDialogue(String prompt, String model) {
        DialogueContext context = DialogueContextBuilder.create().withPrompt(prompt).withModel(model).build();
        return this.executeDialogue(context, new ParameterizedTypeReference<String>(this){});
    }

    @Override
    public <T> T executeDialogue(String prompt, ParameterizedTypeReference<T> responseType) {
        return this.executeDialogue(prompt, null, responseType);
    }

    public <T> T executeDialogue(DialogueContext context, ParameterizedTypeReference<T> responseType) {
        try {
            log.debug("Executing intelligent dialogue with model: {}", (Object)context.getModel());
            ChatClient.CallResponseSpec callSpec = this.buildCallSpecification(context);
            Object result = callSpec.entity(responseType);
            log.debug("Dialogue execution completed successfully");
            return (T)result;
        }
        catch (Exception e) {
            log.error("Dialogue execution failed for model: {}", (Object)context.getModel(), (Object)e);
            throw new BusinessException("\u667a\u80fd\u5bf9\u8bdd\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    protected ChatClient.CallResponseSpec buildCallSpecification(DialogueContext context) {
        ChatClient.ChatClientRequestSpec promptSpec = this.intelligentDialogueClient.prompt();
        if (context.getOptions() != null) {
            promptSpec = promptSpec.options(context.getOptions());
        } else if (context.getModel() != null) {
            ChatOptions runtimeOptions = ChatOptions.builder().model(context.getModel()).build();
            promptSpec = promptSpec.options(runtimeOptions);
        }
        return promptSpec.user(context.getPrompt()).call();
    }

    public <T> T executeAndProcess(DialogueContext context, String processorType) {
        ResponseProcessor<?> processor = this.responseProcessors.get(processorType);
        if (processor == null) {
            throw new IllegalArgumentException("Unknown processor type: " + processorType);
        }
        String rawResponse = this.executeDialogue(context.getPrompt(), context.getModel());
        return (T)processor.process(rawResponse, context);
    }
}

