/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.common.agent.service.transformation;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.ai.generate.tools.common.agent.prompt.PromptHelper;
import com.digiwin.athena.ai.generate.tools.common.agent.service.UniversalIntelligentDialogueService;
import com.digiwin.athena.ai.generate.tools.dto.PythonCovertJavaDTO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class CodeIntelligentTransformationService
extends UniversalIntelligentDialogueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeIntelligentTransformationService.class);

    protected CodeIntelligentTransformationService(ChatClient intelligentDialogueClient) {
        super(intelligentDialogueClient);
    }

    public List<PythonCovertJavaDTO> executePythonCovertJavaDialogue(String pythonCode, String model) {
        log.info("Transformation model:{}, code: \n{}", (Object)model, (Object)pythonCode);
        String batchTransformationPrompt = PromptHelper.buildPythonCovertJavaPrompt(pythonCode);
        List<PythonCovertJavaDTO> transformationResults = this.executeDialogue(batchTransformationPrompt, model, new ParameterizedTypeReference<List<PythonCovertJavaDTO>>(this){});
        log.info("Transformation results: \n{}", (Object)JSONUtil.toJsonStr(transformationResults));
        return transformationResults;
    }

    public List<PythonCovertJavaDTO> executePythonCovertJavaDialogue(String pythonCodel) {
        return this.executePythonCovertJavaDialogue(pythonCodel, null);
    }

    public List<PythonCovertJavaDTO> executeShareDataVariableDialogue(String pythonCodel) {
        String batchTransformationPrompt = PromptHelper.buildShareDataVariablePrompt(pythonCodel);
        List<PythonCovertJavaDTO> transformationResults = this.executeDialogue(batchTransformationPrompt, null, new ParameterizedTypeReference<List<PythonCovertJavaDTO>>(this){});
        log.info("Transformation results: \n{}", (Object)JSONUtil.toJsonStr(transformationResults));
        return transformationResults;
    }
}

