请你作为 E10(ERP) 系统的业务与数据规范专家，基于输入的 JSON 格式数据（包含 E10 系统所有实体名称及各实体对应的全部字段信息），为每个实体以及实体
每个字段严格补全以下 3 项关键内容
仅在原始 JSON 结构中追加字段，不修改任何原有数据、不新增额外实体 / 字段、不删减原有信息：
## 「用途」：清晰说明字段的核心功能定位、数据承载的具体意义，
    明确其在 E10 系统业务流程中承担的核心作用（需结合企业级系统常见场景，如 “存储供应商统一社会信用代码，用于供应商身份唯一标识与合规备案”）；
## 「校验规则」：详细明确字段的全量校验要求，
    包括但不限于：数据类型限制（如字符串 / 数字 / 日期）、长度范围（字符数 / 数值区间）、格式规范（如手机号 / 邮箱 / 身份证格式）、必填 / 可选标识、取值枚举（如有固定可选值需完整列出）、
    唯一性约束、逻辑关联校验（如与其他字段的依赖关系）等（示例：“字符串类型，18 位字符，符合统一社会信用代码格式（含字母与数字），必填，系统内唯一，需与‘供应商名称’联合校验无重复”）；
## 「业务说明」：补充字段关联的具体业务场景、数据来源（如 “注册表单录入”“接口同步自财务系统”）、
    数据去向（如 “同步至采购模块”“用于合同备案”）、与其他字段的业务关联关系、特殊业务规则（如 “仅当‘客户类型’为‘企业客户’时必填”“字段值变更需留存操作日志”）
    、合规要求等（需贴合 E10 系统作为企业级系统的业务逻辑）。
# 输入格式样例
严格遵循 JSON 语法规范，结构示例如下：
```
\{
    "entityList": [
        \{
            "entityName": "MO",
            "displayName": "工单",
            "description": \{
                "purpose": "XXXXX",
                "checkRule": "XXXXX",
                "businessDescription": "XXXX"
            \},
            "columList": [
                \{
                    "name": "LOT_MO_FLAG",
                    "displayName": "批工单",
                    "dataType": "Boolean",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "PLAN_QTY",
                    "displayName": "预计产量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "REQ_QTY",
                    "displayName": "申请数量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "COMPLETED_QTY",
                    "displayName": "已入库量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \}
            ]
        \},
        \{
            "entityName": "MO_ROUTING_D",
            "displayName": "工单工艺单身",
            "description": \{
                "purpose": "XXXXX",
                "checkRule": "XXXXX",
                "businessDescription": "XXXX"
            \},
            "columList": [
                \{
                    "name": "STANDARD_MAN_HOUR",
                    "displayName": "标准人时(秒)",
                    "dataType": "Int32",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "ACT_MAN_HOURS",
                    "displayName": "实际人时(秒)",
                    "dataType": "Int32",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "FIXED_LEAD_TIME",
                    "displayName": "固定前置天数",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "DYNAMIC_LEAD_TIME",
                    "displayName": "变动前置天数",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \}
            ]
        \}
    ]
\}
```
实例字段说明：
- entityList.entityName代表实体名称
- entityList.description 存储模型补全的“用途”“校验规则”“业务说明” 三个字段的内容
- entityList.displayName代表实体的中文含义
- entityList.columList 表示实体对应的字段列表
- entityList.columList[].name 表示实体的属性的名称
- entityList.columList[].displayName 表示实体的属性的的中文含义
- entityList.columList[].dataType 表示实体的属性的数据类型
- entityList.columList[].description 存储模型补全的“用途”“校验规则”“业务说明” 三个字段的内容
# 输出格式样例
严格遵循 JSON 语法规范，结构示例如下：
```
\{
    "success":true|false,
    "entityList": [
        \{
            "entityName": "MO",
            "displayName": "工单",
            "description": \{
                "purpose": "XXXXX",
                "checkRule": "XXXXX",
                "businessDescription": "XXXX"
            \},
            "columList": [
                \{
                    "name": "LOT_MO_FLAG",
                    "displayName": "批工单",
                    "dataType": "Boolean",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "PLAN_QTY",
                    "displayName": "预计产量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "REQ_QTY",
                    "displayName": "申请数量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "COMPLETED_QTY",
                    "displayName": "已入库量",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \}
            ]
        \},
        \{
            "entityName": "MO_ROUTING_D",
            "displayName": "工单工艺单身",
            "description": \{
                "purpose": "XXXXX",
                "checkRule": "XXXXX",
                "businessDescription": "XXXX"
            \},
            "columList": [
                \{
                    "name": "STANDARD_MAN_HOUR",
                    "displayName": "标准人时(秒)",
                    "dataType": "Int32",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "ACT_MAN_HOURS",
                    "displayName": "实际人时(秒)",
                    "dataType": "Int32",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "FIXED_LEAD_TIME",
                    "displayName": "固定前置天数",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \},
                \{
                    "name": "DYNAMIC_LEAD_TIME",
                    "displayName": "变动前置天数",
                    "dataType": "Decimal",
                    "description": \{
                        "purpose": "XXXXX",
                        "checkRule": "XXXXX",
                        "businessDescription": "XXXX"
                    \}
                \}
            ]
        \}
    ]
\}
```
实例字段说明：
- success：是否成功转换
- entityList.entityName代表实体名称
- entityList.description 存储模型补全的“用途”“校验规则”“业务说明” 三个字段的内容
- entityList.displayName代表实体的中文含义
- entityList.columList 表示实体对应的字段列表
- entityList.columList[].name 表示实体的属性的名称
- entityList.columList[].displayName 表示实体的属性的的中文含义
- entityList.columList[].dataType 表示实体的属性的数据类型
- entityList.columList[].description 存储模型补全的“用途”“校验规则”“业务说明” 三个字段的内容

其中description是的JSON对象，具体格式如下
"description":\{
"purpose":"XXXXX",
"checkRule":"XXXXX",
"businessDescription":"XXXX"
\}
中purpose用于存储模型输出的用途，checkRule用于存储模型输出的校验规则，businessDescription用来存储模型输出的业务说明


# 输出格式要求
仅返回补充后的完整 JSON 数据，不添加任何额外说明文字、注释、格式标记或解释性内容；
保持原始 JSON 的层级结构、实体顺序、字段顺序不变，仅在每个字段的原有属性后，依次追加 “用途”“校验规则”“业务说明” 三个字段；
    purpose字段用于存储模型输出的用途，checkRule字段用于存储模型输出的校验规则，businessDescription字段用来存储模型输出的业务说明
确保 JSON 语法合法可解析，无语法错误、无多余逗号、无缺失引号。
请基于 E10 系统的企业级业务特性（如数据合规性、业务流程关联性、字段校验严谨性），
确保补全的内容具备合理性、准确性、针对性，完全适配 E10 系统的业务场景需求。

# 最终要求
**只输出纯JSON数组格式的字符串，不要有任何其他内容！**
严格遵守：你知道就补充，不知道的坚决返回错误信息
# 用户输入数据
{data}