/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.common.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiConfig;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiRequest;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiResponse;
import com.digiwin.athena.ai.generate.tools.common.dto.SclApiInfoHolder;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApi;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiInputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclApiOutputParam;
import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictItemMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityFieldMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.service.GenerateToolsService;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class CommonGenerateToolsService
implements GenerateToolsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonGenerateToolsService.class);
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private SclModuleMapper sclModuleMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclModuleJobMapper sclModuleJobMapper;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Autowired
    private SclEntityFieldMapper sclEntityFieldMapper;
    @Autowired
    private SclDictMapper sclDictMapper;
    @Autowired
    private SclDictItemMapper sclDictItemMapper;
    @Autowired
    private SclQueryCaseMapper sclQueryCaseMapper;
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;
    @Autowired
    private RestTemplate restTemplate;

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        String name = generateRequestDTO.getProductNo();
        String version = generateRequestDTO.getVersion();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        this.sclApiInputParamMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclApiOutputParamMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclApiMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclDictItemMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclEntityFieldMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclDictMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclModuleJobMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclJobMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclEntityMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclQueryCaseMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclBusinessObjectMapper.deleteByProductVersionId(sclProductVersion.getId());
        this.sclModuleMapper.deleteByProductVersionId(sclProductVersion.getId());
        return null;
    }

    public ApiResponse getApiInfo(ApiConfig apiConfig, String apiName) {
        ApiRequest apiRequest = new ApiRequest().setApiName(apiName);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", apiConfig.getToken());
        headers.set("locale", "zh_CN");
        HttpEntity requestEntity = new HttpEntity((Object)JSON.toJSONString((Object)apiRequest), (MultiValueMap)headers);
        ResponseEntity apiResponseResponseEntity = this.restTemplate.exchange(apiConfig.getUrl(), HttpMethod.POST, requestEntity, ApiResponse.class, new Object[0]);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    public Map<String, SclApiInfoHolder> getSclApiInfoHolder(Map<String, ApiResponse> cacheApiMap) {
        return cacheApiMap.entrySet().stream().filter(o -> "000".equals(((ApiResponse)o.getValue()).getResponse().getCode())).collect(Collectors.toMap(Map.Entry::getKey, o -> {
            ApiResponse apiResponse = (ApiResponse)o.getValue();
            SclApiInfoHolder sclApiInfoHolder = new SclApiInfoHolder();
            SclApi sclApi = this.parseSclApi(apiResponse);
            List<SclApiInputParam> sclApiInputParams = this.parseSclApiInputParam(apiResponse);
            List<SclApiOutputParam> sclApiOutputParams = this.parseSclApiOutputParam(apiResponse);
            sclApiInfoHolder.setSclApi(sclApi);
            sclApiInfoHolder.setSclApiInputParams(sclApiInputParams);
            sclApiInfoHolder.setSclApiOutputParams(sclApiOutputParams);
            return sclApiInfoHolder;
        }));
    }

    private List<SclApiOutputParam> parseSclApiOutputParam(ApiResponse apiResponse) {
        ApiResponse.Response response = apiResponse.getResponse();
        List<ApiResponse.Response.RequestMessageSpec> requestMessageSpec = response.getRequestMessageSpec();
        if (CollectionUtils.isEmpty(requestMessageSpec)) {
            return Collections.emptyList();
        }
        return requestMessageSpec.stream().map(o -> {
            SclApiOutputParam sclApiOutputParam = new SclApiOutputParam();
            sclApiOutputParam.setDescription(o.getDataDescription());
            sclApiOutputParam.setName(o.getDataName());
            sclApiOutputParam.setDisplayName(o.getDataDescription());
            sclApiOutputParam.setDataType(o.getDataType());
            sclApiOutputParam.setIsBusinessKey(Boolean.valueOf("Y".equals(o.getIsBusinessKey())));
            sclApiOutputParam.setType(o.getColumnType());
            sclApiOutputParam.setDefaultValue(o.getValue());
            sclApiOutputParam.setIsRequired(Boolean.valueOf("Y".equals(o.getIsRequired())));
            sclApiOutputParam.setIsFilterable(Boolean.valueOf("Y".equals(o.getCanFilter())));
            sclApiOutputParam.setIsSortable(Boolean.valueOf("Y".equals(o.getCanSort())));
            sclApiOutputParam.setDictInfo(o.getListEnum());
            sclApiOutputParam.setIsArray(Boolean.valueOf("Y".equals(o.getIsArray())));
            sclApiOutputParam.setOriginalParentId(o.getParent());
            sclApiOutputParam.setOriginalId(o.getId());
            return sclApiOutputParam;
        }).collect(Collectors.toList());
    }

    private List<SclApiInputParam> parseSclApiInputParam(ApiResponse apiResponse) {
        ApiResponse.Response response = apiResponse.getResponse();
        List<ApiResponse.Response.RequestMessageSpec> requestMessageSpec = response.getRequestMessageSpec();
        if (CollectionUtils.isEmpty(requestMessageSpec)) {
            return Collections.emptyList();
        }
        return requestMessageSpec.stream().map(o -> {
            SclApiInputParam sclApiInputParam = new SclApiInputParam();
            sclApiInputParam.setDescription(o.getDataDescription());
            sclApiInputParam.setName(o.getDataName());
            sclApiInputParam.setDisplayName(o.getDataDescription());
            sclApiInputParam.setDataType(o.getDataType());
            sclApiInputParam.setIsBusinessKey(Boolean.valueOf("Y".equals(o.getIsBusinessKey())));
            sclApiInputParam.setType(o.getColumnType());
            sclApiInputParam.setDefaultValue(o.getValue());
            sclApiInputParam.setIsRequired(Boolean.valueOf("Y".equals(o.getIsRequired())));
            sclApiInputParam.setIsFilterable(Boolean.valueOf("Y".equals(o.getCanFilter())));
            sclApiInputParam.setIsSortable(Boolean.valueOf("Y".equals(o.getCanSort())));
            sclApiInputParam.setDictInfo(o.getListEnum());
            sclApiInputParam.setIsArray(Boolean.valueOf("Y".equals(o.getIsArray())));
            sclApiInputParam.setOriginalParentId(o.getParent());
            sclApiInputParam.setOriginalId(o.getId());
            return sclApiInputParam;
        }).collect(Collectors.toList());
    }

    private SclApi parseSclApi(ApiResponse apiResponse) {
        ApiResponse.Response response = apiResponse.getResponse();
        if (response.getCode().equals("000")) {
            SclApi sclApi = new SclApi();
            sclApi.setName(response.getApiName());
            sclApi.setDescription(response.getDescription());
            sclApi.setVersion(response.getApiVersion());
            sclApi.setMethod(response.getRequestMethod());
            sclApi.setDisplayName(response.getDescription());
            sclApi.setInvokeType(response.getInvokeType());
            return sclApi;
        }
        return null;
    }

    protected void saveSclApi(Map<String, SclBusinessObject> businessObjectMap, LinkedMultiValueMap<String, String> apiName2PageDesignCodeMap, Map<String, SclApiInfoHolder> sclApiInfoHolder) {
        Map<String, List> muteMap = sclApiInfoHolder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> {
            List businessCodes = (List)apiName2PageDesignCodeMap.getOrDefault(o.getKey(), new ArrayList());
            return businessCodes.stream().map(s -> {
                SclApiInfoHolder sclApiInfoHolder1 = (SclApiInfoHolder)JSON.parseObject((String)JSON.toJSONString(o.getValue()), SclApiInfoHolder.class);
                sclApiInfoHolder1.getSclApi().setId(Long.valueOf(this.getNextId()));
                sclApiInfoHolder1.getSclApi().setBusinessObjectId(businessObjectMap.getOrDefault(s, new SclBusinessObject()).getId());
                sclApiInfoHolder1.getSclApi().setProductVersionId(businessObjectMap.getOrDefault(s, new SclBusinessObject()).getProductVersionId());
                return sclApiInfoHolder1;
            }).collect(Collectors.toList());
        }));
        Set sclApiSet = muteMap.values().stream().flatMap(Collection::stream).map(SclApiInfoHolder::getSclApi).filter(o -> o.getBusinessObjectId() != null).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sclApiSet)) {
            this.sclApiMapper.insert(sclApiSet);
        }
        muteMap.forEach((key, value) -> {
            value.forEach(api -> api.getSclApiOutputParams().forEach(outputParam -> {
                outputParam.setId(Long.valueOf(this.getNextId()));
                outputParam.setApiId(api.getSclApi().getId());
                outputParam.setProductVersionId(api.getSclApi().getProductVersionId());
            }));
            value.forEach(api -> api.getSclApiInputParams().forEach(inputParam -> {
                inputParam.setId(Long.valueOf(this.getNextId()));
                inputParam.setApiId(api.getSclApi().getId());
                inputParam.setProductVersionId(api.getSclApi().getProductVersionId());
            }));
        });
        muteMap.values().forEach(api -> api.forEach(o -> {
            this.saveInputParams((SclApiInfoHolder)o);
            this.saveOutputParams((SclApiInfoHolder)o);
        }));
    }

    private void saveInputParams(SclApiInfoHolder sclApiInfoHolder) {
        Set sclApiInputParams = sclApiInfoHolder.getSclApiInputParams().stream().filter(o -> o.getApiId() != null).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sclApiInputParams)) {
            Set sclApiInputParamsTop = sclApiInputParams.stream().filter(o -> o.getOriginalParentId() == null).collect(Collectors.toSet());
            this.sclApiInputParamMapper.insert(sclApiInputParamsTop);
            sclApiInputParams.removeAll(sclApiInputParamsTop);
            while (!sclApiInputParams.isEmpty()) {
                Map topOriginalIdIdMap = sclApiInputParamsTop.stream().collect(Collectors.toMap(SclApiInputParam::getOriginalId, Function.identity()));
                Set<SclApiInputParam> sclApiInputParams1 = sclApiInputParams.stream().filter(o -> topOriginalIdIdMap.containsKey(o.getOriginalParentId())).collect(Collectors.toSet());
                sclApiInputParams1.forEach(o -> o.setParentId(((SclApiInputParam)topOriginalIdIdMap.get(o.getOriginalParentId())).getId()));
                if (sclApiInputParams1.isEmpty()) break;
                this.sclApiInputParamMapper.insert(sclApiInputParams1);
                sclApiInputParamsTop = sclApiInputParams1;
                sclApiInputParams.removeAll(sclApiInputParamsTop);
            }
        }
    }

    private void saveOutputParams(SclApiInfoHolder sclApiInfoHolder) {
        Set sclApiOutputParams = sclApiInfoHolder.getSclApiOutputParams().stream().filter(o -> o.getApiId() != null).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sclApiOutputParams)) {
            Set sclApiOutputParamsTop = sclApiOutputParams.stream().filter(o -> o.getOriginalParentId() == null).collect(Collectors.toSet());
            this.sclApiOutputParamMapper.insert(sclApiOutputParamsTop);
            sclApiOutputParams.removeAll(sclApiOutputParamsTop);
            while (!sclApiOutputParams.isEmpty()) {
                Map topOriginalIdIdMap = sclApiOutputParamsTop.stream().collect(Collectors.toMap(SclApiOutputParam::getOriginalId, Function.identity()));
                Set<SclApiOutputParam> sclApiInputParams1 = sclApiOutputParams.stream().filter(o -> topOriginalIdIdMap.containsKey(o.getOriginalParentId())).collect(Collectors.toSet());
                sclApiInputParams1.forEach(o -> o.setParentId(((SclApiOutputParam)topOriginalIdIdMap.get(o.getOriginalParentId())).getId()));
                if (sclApiInputParams1.isEmpty()) break;
                this.sclApiOutputParamMapper.insert(sclApiInputParams1);
                sclApiOutputParamsTop = sclApiInputParams1;
                sclApiOutputParams.removeAll(sclApiOutputParamsTop);
            }
        }
    }

    public long getNextId() {
        return IdUtil.getId();
    }
}

