/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.common.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiConfig;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiRequest;
import com.digiwin.athena.ai.generate.tools.common.dto.ApiResponse;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProduct;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiInputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclApiOutputParamMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictItemMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclDictMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclEntityRelationMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclFunctionRuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobFunctionMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutComponentMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclLayoutMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleJobMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclModuleMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclOpenwindowMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclProductVersionMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclQueryCaseMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataRelationMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclShareDataVariableMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclTableFieldMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclTableMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclUiEntityMapper;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclUiEntityPropertyMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.service.GenerateToolsService;
import com.digiwin.athena.ai.generate.tools.util.IdUtil;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.RestTemplate;

public abstract class CommonGenerateToolsService
implements GenerateToolsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonGenerateToolsService.class);
    @Autowired
    private SclProductMapper sclProductMapper;
    @Autowired
    private SclProductVersionMapper sclProductVersionMapper;
    @Autowired
    private SclModuleMapper sclModuleMapper;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;
    @Autowired
    private SclJobMapper sclJobMapper;
    @Autowired
    private SclModuleJobMapper sclModuleJobMapper;
    @Autowired
    private SclEntityMapper sclEntityMapper;
    @Autowired
    private SclEntityPropertyMapper sclEntityPropertyMapper;
    @Autowired
    private SclDictMapper sclDictMapper;
    @Autowired
    private SclDictItemMapper sclDictItemMapper;
    @Autowired
    private SclQueryCaseMapper sclQueryCaseMapper;
    @Autowired
    private SclApiMapper sclApiMapper;
    @Autowired
    private SclApiInputParamMapper sclApiInputParamMapper;
    @Autowired
    private SclApiOutputParamMapper sclApiOutputParamMapper;
    @Autowired
    private SclJobFunctionMapper sclJobFunctionMapper;
    @Autowired
    private SclLayoutComponentMapper sclLayoutComponentMapper;
    @Autowired
    private SclLayoutMapper sclLayoutMapper;
    @Autowired
    private SclFunctionRuleMapper sclFunctionRuleMapper;
    @Autowired
    private SclTableMapper sclTableMapper;
    @Autowired
    private SclTableFieldMapper sclTableFieldMapper;
    @Autowired
    private SclShareDataRelationMapper sclShareDataRelationMapper;
    @Autowired
    private SclUiEntityMapper sclUiEntityMapper;
    @Autowired
    private SclUiEntityPropertyMapper sclUiEntityPropertyMapper;
    @Autowired
    private SclEntityRelationMapper sclEntityRelationMapper;
    @Autowired
    private SclOpenwindowMapper sclOpenwindowMapper;
    @Autowired
    private SclShareDataVariableMapper sclShareDataVariableMapper;
    @Autowired
    private RestTemplate restTemplate;

    public static void deleteInBatches(Supplier<Integer> supplier, Runnable runnable) {
        Integer t;
        while ((t = supplier.get()) != 0) {
            runnable.run();
        }
    }

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        String name = generateRequestDTO.getProductNo();
        String version = generateRequestDTO.getVersion();
        SclProduct sclProduct = this.sclProductMapper.selectByName(name);
        if (sclProduct == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1", name));
        }
        SclProductVersion sclProductVersion = this.sclProductVersionMapper.selectByProductIdAndVersion(sclProduct.getId(), version);
        if (sclProductVersion == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u540d\u79f0\u662f\u3010%s\u3011\u7684\u4ea7\u54c1\u7684\u3010%s\u3011\u7248\u672c", name, version));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(generateRequestDTO.getProductNo() + "_" + generateRequestDTO.getVersion() + "-->\u3010\u6e05\u7406\u6570\u636e\u3011");
        log.info("\u5f00\u59cb\u5220\u9664 sclUiEntityPropertyMapper");
        this.sclUiEntityPropertyMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664 sclUiEntityMapper");
        this.sclUiEntityMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclLayoutComponentMapper");
        this.sclLayoutComponentMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclLayoutMapper");
        this.sclLayoutMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclApiInputParamMapper");
        this.sclApiInputParamMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclApiOutputParamMapper");
        this.sclApiOutputParamMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclOpenwindowMapper");
        this.sclOpenwindowMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclFunctionRuleMapper");
        this.sclFunctionRuleMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclJobFunctionMapper");
        this.sclJobFunctionMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclApiMapper");
        this.sclApiMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclDictItemMapper");
        this.sclDictItemMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclTableFieldMapper");
        this.sclTableFieldMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclEntityRelationMapper");
        this.sclEntityRelationMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclEntityPropertyMapper");
        this.sclEntityPropertyMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclDictMapper");
        this.sclDictMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclModuleJobMapper");
        this.sclModuleJobMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclJobMapper");
        this.sclJobMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclTableMapper");
        this.sclTableMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclEntityMapper");
        this.sclEntityMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclQueryCaseMapper");
        this.sclQueryCaseMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclShareDataRelationMapper");
        this.sclShareDataRelationMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclShareDataVariableMapper");
        this.sclShareDataVariableMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclBusinessObjectMapper");
        this.sclBusinessObjectMapper.deleteByProductVersionId(sclProductVersion.getId());
        log.info("\u5f00\u59cb\u5220\u9664sclModuleMapper");
        this.sclModuleMapper.deleteByProductVersionId(sclProductVersion.getId());
        stopWatch.stop();
        log.info(stopWatch.prettyPrint());
        return null;
    }

    public ApiResponse getApiInfo(ApiConfig apiConfig, String apiName) {
        ApiRequest apiRequest = new ApiRequest().setApiName(apiName);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", apiConfig.getToken());
        headers.set("locale", "zh_CN");
        HttpEntity requestEntity = new HttpEntity((Object)JSON.toJSONString((Object)apiRequest), (MultiValueMap)headers);
        ResponseEntity apiResponseResponseEntity = this.restTemplate.exchange(apiConfig.getUrl(), HttpMethod.POST, requestEntity, ApiResponse.class, new Object[0]);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    public long getNextId() {
        return IdUtil.getId();
    }
}

