/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

public class ShortIdUtil {
    private static final long START_STMP = 1704067200000L;
    private static final long SEQUENCE_BIT = 10L;
    private static final long MACHINE_BIT = 4L;
    private static final long DATACENTER_BIT = 4L;
    private static final long MAX_DATACENTER_NUM = 15L;
    private static final long MAX_MACHINE_NUM = 15L;
    private static final long MAX_SEQUENCE = 1023L;
    private static final long MACHINE_LEFT = 10L;
    private static final long DATACENTER_LEFT = 14L;
    private static final long TIMESTMP_LEFT = 18L;
    private long datacenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public ShortIdUtil(long datacenterId, long machineId) {
        if (datacenterId > 15L || datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than 15 or less than 0");
        }
        if (machineId > 15L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than 15 or less than 0");
        }
        this.datacenterId = datacenterId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        long id = currStmp - 1704067200000L << 18 | this.datacenterId << 14 | this.machineId << 10 | this.sequence;
        return id;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        ShortIdUtil idGenerator = new ShortIdUtil(1L, 1L);
        for (int i = 0; i < 100; ++i) {
            long id = idGenerator.nextId();
            System.out.println("\u751f\u6210\u7684ID: " + id + ", \u957f\u5ea6: " + String.valueOf(id).length());
        }
    }
}

