/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeUtil {
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_DATE_SLASH = "yyyy/MM/dd";
    public static final String PATTERN_DATE_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATETIME_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String PATTERN_DATETIME_COMPACT = "yyyyMMddHHmmss";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_TIME_HM = "HH:mm";
    public static final String PATTERN_MONTH = "yyyy-MM";
    public static final String PATTERN_YEAR = "yyyy";
    private static final String[] WEEK_DAYS_CN = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final String[] WEEK_DAYS_CN_SHORT = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    private DateTimeUtil() {
    }

    public static String getCurrentDayOfWeekCN() {
        return DateTimeUtil.getDayOfWeekCN(LocalDate.now());
    }

    public static String getDayOfWeekCN(LocalDate date) {
        if (date == null) {
            return null;
        }
        int dayOfWeek = date.getDayOfWeek().getValue();
        return WEEK_DAYS_CN[dayOfWeek % 7];
    }

    public static String getDayOfWeekCN(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeUtil.getDayOfWeekCN(dateTime.toLocalDate());
    }

    public static String getDayOfWeekCN(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtil.getDayOfWeekCN(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static String getCurrentDayOfWeekShortCN() {
        return DateTimeUtil.getDayOfWeekShortCN(LocalDate.now());
    }

    public static String getDayOfWeekShortCN(LocalDate date) {
        if (date == null) {
            return null;
        }
        int dayOfWeek = date.getDayOfWeek().getValue();
        return WEEK_DAYS_CN_SHORT[dayOfWeek % 7];
    }

    public static String getDayOfWeekShortCN(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeUtil.getDayOfWeekShortCN(dateTime.toLocalDate());
    }

    public static String getDayOfWeekShortCN(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtil.getDayOfWeekShortCN(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static int getCurrentDayOfWeek() {
        return DateTimeUtil.getDayOfWeek(LocalDate.now());
    }

    public static int getDayOfWeek(LocalDate date) {
        if (date == null) {
            return -1;
        }
        return date.getDayOfWeek().getValue();
    }

    public static String getCurrentDate() {
        return DateTimeUtil.formatDate(LocalDate.now());
    }

    public static String getCurrentDateTime() {
        return DateTimeUtil.formatDateTime(LocalDateTime.now());
    }

    public static String getCurrentTimestamp() {
        return DateTimeUtil.formatTimestamp(LocalDateTime.now());
    }

    public static String getCurrentDateTime(String pattern) {
        return DateTimeUtil.format(LocalDateTime.now(), pattern);
    }

    public static String formatDate(LocalDate date) {
        return DateTimeUtil.formatDate(date, PATTERN_DATE);
    }

    public static String formatDate(LocalDate date, String pattern) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        return DateTimeUtil.formatDateTime(dateTime, PATTERN_DATETIME);
    }

    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatTimestamp(LocalDateTime dateTime) {
        return DateTimeUtil.formatDateTime(dateTime, PATTERN_DATETIME_MS);
    }

    public static String formatCompact(LocalDateTime dateTime) {
        return DateTimeUtil.formatDateTime(dateTime, PATTERN_DATETIME_COMPACT);
    }

    public static String formatDate(Date date) {
        return DateTimeUtil.formatDate(date, PATTERN_DATE);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return DateTimeUtil.formatDateTime(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), pattern);
    }

    public static String formatDateTime(Date date) {
        return DateTimeUtil.formatDate(date, PATTERN_DATETIME);
    }

    public static String formatDateTime(Timestamp timestamp) {
        return DateTimeUtil.formatDateTime(timestamp, PATTERN_DATETIME);
    }

    public static String formatDateTime(Timestamp timestamp, String pattern) {
        if (timestamp == null) {
            return null;
        }
        return DateTimeUtil.formatDateTime(timestamp.toLocalDateTime(), pattern);
    }

    public static String format(LocalDateTime dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        try {
            return dateTime.format(DateTimeFormatter.ofPattern(pattern));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid pattern: " + pattern, e);
        }
    }

    public static String format(LocalDate date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            return date.format(DateTimeFormatter.ofPattern(pattern));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid pattern: " + pattern, e);
        }
    }

    public static String getCurrentDateCN() {
        return DateTimeUtil.formatDate(LocalDate.now(), PATTERN_DATE_CN);
    }

    public static String getCurrentDateSlash() {
        return DateTimeUtil.formatDate(LocalDate.now(), PATTERN_DATE_SLASH);
    }

    public static String getCurrentTime() {
        return DateTimeUtil.formatDateTime(LocalDateTime.now(), PATTERN_TIME);
    }

    public static String getCurrentYearMonth() {
        return DateTimeUtil.formatDate(LocalDate.now(), PATTERN_MONTH);
    }

    public static String getCurrentYear() {
        return DateTimeUtil.formatDate(LocalDate.now(), PATTERN_YEAR);
    }

    public static String getCurrentCompact() {
        return DateTimeUtil.formatCompact(LocalDateTime.now());
    }

    public static String getCurrentDateWithWeek() {
        return DateTimeUtil.getCurrentDate() + " " + DateTimeUtil.getCurrentDayOfWeekCN();
    }

    public static String getCurrentDateCNWithWeek() {
        return DateTimeUtil.getCurrentDateCN() + " " + DateTimeUtil.getCurrentDayOfWeekCN();
    }
}

