/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import java.net.InetAddress;

public final class Snowflake53 {
    private static final Snowflake53 INSTANCE = new Snowflake53();
    private static final long EPOCH = 1577836800000L;
    private static final int MACHINE_BITS = 5;
    private static final int SEQ_BITS = 7;
    private static final long MAX_MACHINE = 31L;
    private static final long MAX_SEQ = 127L;
    private static final int MACHINE_SHIFT = 7;
    private static final int TIMESTAMP_SHIFT = 12;
    private final long machineId = Snowflake53.getMachineId();
    private long lastStamp = -1L;
    private long sequence = 0L;

    public static long nextId() {
        return INSTANCE.genId();
    }

    private Snowflake53() {
        if (this.machineId < 0L || this.machineId > 31L) {
            throw new IllegalArgumentException("machine.id must be 0~31");
        }
    }

    private synchronized long genId() {
        long curr = System.currentTimeMillis();
        if (curr < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards!");
        }
        if (curr == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0x7FL;
            if (this.sequence == 0L) {
                curr = this.tilNextMillis(this.lastStamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = curr;
        return curr - 1577836800000L << 12 | this.machineId << 7 | this.sequence;
    }

    private long tilNextMillis(long last) {
        long now;
        while ((now = System.currentTimeMillis()) <= last) {
        }
        return now;
    }

    private static long getMachineId() {
        try {
            int ip = InetAddress.getLocalHost().getAddress()[3] & 0xFF;
            return (long)ip & 0x1FL;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 20; ++i) {
            long id = Snowflake53.nextId();
            System.out.println(id + "  length=" + String.valueOf(id).length());
        }
    }
}

