/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.ai.generate.tools.util.RedisUtils;
import com.digiwin.athena.ai.generate.tools.util.SpringBeanUtil;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;

public class CacheUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheUtil.class);
    private static final String REDIS_KEY_PRE_FIX = "ai:tools:cache:";
    private static RedisUtils redisUtils;

    public static <T> T getData(Supplier<T> business, TypeReference<T> typeReference, String key, Object ... fields) {
        try {
            String cacheKey = null;
            try {
                cacheKey = CacheUtil.generateCacheKey(fields);
            }
            catch (Exception e) {
                return business.get();
            }
            String cachedResult = CacheUtil.getRedis().hget(REDIS_KEY_PRE_FIX + key, cacheKey);
            if (cachedResult != null) {
                return (T)JSONUtil.toBean((String)cachedResult, typeReference, (boolean)false);
            }
            T result = business.get();
            String resultJson = JSONUtil.toJsonStr(result);
            CacheUtil.getRedis().hset(REDIS_KEY_PRE_FIX + key, cacheKey, resultJson);
            return result;
        }
        catch (Exception e) {
            log.error("\u5403\u6389\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void setData(Object data, String key, Object ... fields) {
        try {
            String cacheKey = CacheUtil.generateCacheKey(fields);
            String resultJson = JSONUtil.toJsonStr((Object)data);
            CacheUtil.getRedis().hset(REDIS_KEY_PRE_FIX + key, cacheKey, resultJson);
        }
        catch (Exception e) {
            log.error("\u5403\u6389\u5f02\u5e38", (Throwable)e);
        }
    }

    public static <T> T getData(TypeReference<T> typeReference, String key, Object ... fields) {
        try {
            String cacheKey = CacheUtil.generateCacheKey(fields);
            String cachedResult = CacheUtil.getRedis().hget(REDIS_KEY_PRE_FIX + key, cacheKey);
            if (cachedResult != null) {
                return (T)JSONUtil.toBean((String)cachedResult, typeReference, (boolean)false);
            }
        }
        catch (Exception e) {
            log.error("\u5403\u6389\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private static String generateCacheKey(Object ... keys) {
        StringBuilder keyBuilder = new StringBuilder();
        for (Object key : keys) {
            if (Objects.isNull(key)) continue;
            if (key instanceof String) {
                keyBuilder.append(key).append(":");
                continue;
            }
            String jsonString = JSONUtil.toJsonStr((Object)key);
            keyBuilder.append(jsonString).append(":");
        }
        if (keyBuilder.charAt(keyBuilder.length() - 1) == ':') {
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        return DigestUtil.md5Hex((String)keyBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisUtils getRedis() {
        if (!Objects.isNull(redisUtils)) return redisUtils;
        Class<CacheUtil> clazz = CacheUtil.class;
        synchronized (CacheUtil.class) {
            if (!Objects.isNull(redisUtils)) return redisUtils;
            RedisProperties properties = SpringBeanUtil.getBean(RedisProperties.class);
            redisUtils = new RedisUtils(properties);
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtils;
        }
    }
}

