/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConfigUtils {
    private static Environment environment;

    @Autowired
    public void setEnvironment(Environment env) {
        environment = env;
    }

    private static Environment getEnvironment() {
        if (environment == null) {
            throw new IllegalStateException("ConfigUtils\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u4fddSpring\u5bb9\u5668\u5df2\u542f\u52a8\u5b8c\u6210");
        }
        return environment;
    }

    public static String getString(String key) {
        return ConfigUtils.getString(key, null);
    }

    public static String getString(String key, String defaultValue) {
        return ConfigUtils.getEnvironment().getProperty(key, defaultValue);
    }

    public static Integer getInteger(String key) {
        return ConfigUtils.getInteger(key, null);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        try {
            return (Integer)ConfigUtils.getEnvironment().getProperty(key, Integer.class, (Object)defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long getLong(String key, Long defaultValue) {
        try {
            return (Long)ConfigUtils.getEnvironment().getProperty(key, Long.class, (Object)defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            return (Boolean)ConfigUtils.getEnvironment().getProperty(key, Boolean.class, (Object)defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double getDouble(String key, Double defaultValue) {
        try {
            return (Double)ConfigUtils.getEnvironment().getProperty(key, Double.class, (Object)defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static List<String> getList(String key, List<String> defaultValue) {
        String value = ConfigUtils.getEnvironment().getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return Arrays.asList(value.split(","));
    }

    public static List<String> getList(String key) {
        return ConfigUtils.getList(key, null);
    }

    public static boolean contains(String key) {
        return ConfigUtils.getEnvironment().containsProperty(key);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        try {
            return (T)ConfigUtils.getEnvironment().getProperty(key, targetType, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T> T getProperty(String key, Class<T> targetValueType) {
        return (T)ConfigUtils.getEnvironment().getProperty(key, targetValueType);
    }

    public static String[] getActiveProfiles() {
        return ConfigUtils.getEnvironment().getActiveProfiles();
    }

    public static String[] getDefaultProfiles() {
        return ConfigUtils.getEnvironment().getDefaultProfiles();
    }

    public static boolean hasProfile(String profile) {
        for (String activeProfile : ConfigUtils.getActiveProfiles()) {
            if (!activeProfile.equals(profile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDev() {
        return ConfigUtils.hasProfile("dev");
    }

    public static boolean isTest() {
        return ConfigUtils.hasProfile("test");
    }

    public static boolean isProd() {
        return ConfigUtils.hasProfile("prod");
    }
}

