/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;

public class MDCUtil {
    private static final String TRACE_ID_MDC_KEY = "traceId";

    public static Map<String, String> getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> contextMap) {
        if (contextMap != null) {
            MDC.setContextMap(contextMap);
        }
    }

    public static void clear() {
        MDC.clear();
    }

    public static String getTraceId() {
        return MDC.get((String)TRACE_ID_MDC_KEY);
    }

    public static void setTraceId(String traceId) {
        if (traceId != null) {
            MDC.put((String)TRACE_ID_MDC_KEY, (String)traceId);
        }
    }

    public static TaskDecorator mdcTaskDecorator() {
        return runnable -> {
            Map<String, String> contextMap = MDCUtil.getCopyOfContextMap();
            return () -> {
                try {
                    MDCUtil.setContextMap(contextMap);
                    runnable.run();
                }
                finally {
                    MDCUtil.clear();
                }
            };
        };
    }
}

