/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.util;

import cn.hutool.json.JSONUtil;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.SetParams;

public class RedisUtils
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private JedisPool jedisPool;
    private final RedisProperties config;
    private static final ThreadLocal<Jedis> threadLocalJedis = new ThreadLocal();

    public RedisUtils() {
        this.config = new RedisProperties();
        this.initPool();
        this.registerShutdownHook();
    }

    public RedisUtils(RedisProperties config) {
        if (config == null) {
            config = new RedisProperties();
        }
        this.config = config;
        this.initPool();
        this.registerShutdownHook();
    }

    private void initPool() {
        try {
            RedisProperties.Pool pool = this.config.getJedis().getPool();
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(pool.getMaxActive());
            poolConfig.setMaxIdle(pool.getMaxIdle());
            poolConfig.setMinIdle(pool.getMinIdle());
            if (pool.getMaxWait() != null) {
                poolConfig.setMaxWait(pool.getMaxWait());
            }
            Duration timeout = this.config.getTimeout();
            this.jedisPool = this.config.getPassword() != null && !this.config.getPassword().isEmpty() ? new JedisPool((GenericObjectPoolConfig)poolConfig, this.config.getHost(), this.config.getPort(), timeout == null ? 2000 : (int)timeout.toMillis(), this.config.getPassword(), this.config.getDatabase()) : new JedisPool((GenericObjectPoolConfig)poolConfig, this.config.getHost(), this.config.getPort(), timeout == null ? 2000 : (int)timeout.toMillis(), null, this.config.getDatabase());
            log.info("Redis\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u6210\u529f: " + this.config.getHost() + ":" + this.config.getPort());
        }
        catch (Exception e) {
            log.error("Redis\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            throw new RuntimeException("Redis\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public Jedis getJedis() {
        try {
            return this.jedisPool.getResource();
        }
        catch (Exception e) {
            throw new JedisException("\u83b7\u53d6Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public Jedis getThreadJedis() {
        Jedis jedis = threadLocalJedis.get();
        if (jedis == null) {
            jedis = this.getJedis();
            threadLocalJedis.set(jedis);
        }
        return jedis;
    }

    public void closeThreadJedis() {
        Jedis jedis = threadLocalJedis.get();
        if (jedis != null) {
            jedis.close();
            threadLocalJedis.remove();
        }
    }

    public String set(String key, String value) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    public String setex(String key, int seconds, String value) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.setex(key, (long)seconds, value);
            return string;
        }
    }

    public String set(String key, String value, SetParams params) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.set(key, value, params);
            return string;
        }
    }

    public String get(String key) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.get(key);
            return string;
        }
    }

    public String setObject(String key, Object value) {
        String string;
        block8: {
            Jedis jedis = this.getJedis();
            try {
                String json = JSONUtil.toJsonStr((Object)value);
                string = jedis.set(key, json);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5bf9\u8c61\u5e8f\u5217\u5316\u5931\u8d25", e);
                }
            }
            jedis.close();
        }
        return string;
    }

    public String setObject(String key, Object value, int seconds) {
        String string;
        block8: {
            Jedis jedis = this.getJedis();
            try {
                String json = JSONUtil.toJsonStr((Object)value);
                string = jedis.setex(key, (long)seconds, json);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5bf9\u8c61\u5e8f\u5217\u5316\u5931\u8d25", e);
                }
            }
            jedis.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getObject(String key, Class<T> clazz) {
        try (Jedis jedis = this.getJedis();){
            String json = jedis.get(key);
            if (json == null) {
                T t = null;
                return t;
            }
            Object object = JSONUtil.toBean((String)json, clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    public Long del(String ... keys) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.del(keys);
            return l;
        }
    }

    public Long expire(String key, int seconds) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.expire(key, (long)seconds);
            return l;
        }
    }

    public Long pexpire(String key, long milliseconds) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.pexpire(key, milliseconds);
            return l;
        }
    }

    public Boolean exists(String key) {
        try (Jedis jedis = this.getJedis();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public Long hset(String key, String field, String value) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    public String hget(String key, String field) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.hget(key, field);
            return string;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = this.getJedis();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }

    public Long lpush(String key, String ... values) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.lpush(key, values);
            return l;
        }
    }

    public Long rpush(String key, String ... values) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.rpush(key, values);
            return l;
        }
    }

    public String lpop(String key) {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.lpop(key);
            return string;
        }
    }

    public Long sadd(String key, String ... members) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.sadd(key, members);
            return l;
        }
    }

    public Set<String> smembers(String key) {
        try (Jedis jedis = this.getJedis();){
            Set set = jedis.smembers(key);
            return set;
        }
    }

    public boolean tryLock(String lockKey, String lockValue, long expireSeconds) {
        try (Jedis jedis = this.getJedis();){
            String result = jedis.set(lockKey, lockValue, SetParams.setParams().nx().ex(expireSeconds));
            boolean bl = "OK".equals(result);
            return bl;
        }
    }

    public boolean releaseLock(String lockKey, String lockValue) {
        try (Jedis jedis = this.getJedis();){
            String luaScript = "if redis.call('get', KEYS[1]) == ARGV[1] then\n    return redis.call('del', KEYS[1])\nelse\n    return 0\nend\n";
            Object result = jedis.eval(luaScript, Collections.singletonList(lockKey), Collections.singletonList(lockValue));
            boolean bl = Long.valueOf(1L).equals(result);
            return bl;
        }
    }

    public Long ttl(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.ttl(key);
            return l;
        }
    }

    public Long incr(String key) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.incr(key);
            return l;
        }
    }

    public Long incrBy(String key, long increment) {
        try (Jedis jedis = this.getJedis();){
            Long l = jedis.incrBy(key, increment);
            return l;
        }
    }

    public boolean ping() {
        boolean bl;
        block8: {
            Jedis jedis = this.getJedis();
            try {
                bl = "PONG".equals(jedis.ping());
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            jedis.close();
        }
        return bl;
    }

    @Override
    public void close() {
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            this.jedisPool.close();
            log.info("Redis\u8fde\u63a5\u6c60\u5df2\u5173\u95ed");
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95edRedis\u8fde\u63a5\u6c60\u65f6\u51fa\u9519", (Throwable)e);
            }
        }));
    }

    public String getPoolStatus() {
        if (this.jedisPool == null) {
            return "\u8fde\u63a5\u6c60\u672a\u521d\u59cb\u5316";
        }
        return String.format("Active: %d, Idle: %d, Waiters: %d", this.jedisPool.getNumActive(), this.jedisPool.getNumIdle(), this.jedisPool.getNumWaiters());
    }

    public String flushDB() {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.flushDB();
            return string;
        }
    }

    public String flushAll() {
        try (Jedis jedis = this.getJedis();){
            String string = jedis.flushAll();
            return string;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        String poolStatus;
        RedisProperties redisProperties = new RedisProperties();
        redisProperties.setHost("localhost");
        redisProperties.setPort(6379);
        try (RedisUtils redisUtils = new RedisUtils(redisProperties);){
            redisUtils.hset("test:1", "1", "1");
            redisUtils.hset("test:2", "2", "2");
            redisUtils.hget("test:1", "1");
            poolStatus = redisUtils.getPoolStatus();
            System.out.println(poolStatus);
        }
        redisUtils = new RedisUtils();
        try {
            redisUtils.hset("test:1", "1", "1");
            redisUtils.hset("test:2", "2", "2");
            redisUtils.hget("test:1", "1");
            poolStatus = redisUtils.getPoolStatus();
            System.out.println(poolStatus);
        }
        finally {
            redisUtils.close();
        }
    }
}

