/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.entity;

import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.entity.DataEntityType;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.entity.MetadataContainer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class JaxbParserMain {
    public static List<String> getPaths() {
        String path = "C:\\Users\\Alor\\Desktop\\\u65b0\u5efa\u6587\u4ef6\u5939\\E80KF-20251011092257\\Server\\Application\\BusinessObjects";
        List<String> filePathsWithFileName = FileLister.getFilePathsWithFileName(path, "MetadataContainer.dcxml", 2);
        return filePathsWithFileName;
    }

    public static void parseMateFile() {
        List<String> paths = JaxbParserMain.getPaths();
        if (CollectionUtils.isNotEmpty(paths)) {
            JaxbParserMain.parse("C:\\Users\\Alor\\Desktop\\\u65b0\u5efa\u6587\u4ef6\u5939\\E80KF-20251011092257\\Server\\Application\\BusinessObjects\\MO_BATCH_CHANGE\\MetadataContainer.dcxml");
        }
    }

    public static void main(String[] args) {
        JaxbParserMain.parseMateFile();
    }

    public static void parse(String xmlFilePath) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetadataContainer.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File xmlFile = new File(xmlFilePath);
            MetadataContainer metadataContainer = (MetadataContainer)unmarshaller.unmarshal(xmlFile);
            for (DataEntityType det : metadataContainer.getDataEntityTypes()) {
                JaxbParserMain.printDataEntityType(det);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static void printDataEntityType(DataEntityType det) {
        System.out.println("----------------------------------------");
        System.out.println("Data Entity Type: " + det.getName() + " (" + det.getDisplayName() + ")");
        System.out.println("  Type: " + det.getDataEntityTypeType());
        System.out.println("  Primary Key: " + det.getPrimaryKey());
        System.out.println("  Business Primary Key: " + det.getBusinessPrimaryKey());
        if (det.getProperties().getSimpleProperties() != null && !det.getProperties().getSimpleProperties().isEmpty()) {
            System.out.println("  Simple Properties:");
            det.getProperties().getSimpleProperties().forEach(p -> {
                System.out.printf("    - %s: %s (DB Type: %s)%n", p.getName(), p.getDisplayName(), p.getDbType());
                if (!ObjectUtils.isEmpty((Object)p.getBusinessTypeName())) {
                    // empty if block
                }
            });
        }
        if (det.getProperties().getReferenceProperties() != null && !det.getProperties().getReferenceProperties().isEmpty()) {
            System.out.println("  Reference Properties:");
            det.getProperties().getReferenceProperties().forEach(p -> System.out.printf("    - %s: %s (DB Type: %s) %s %n", p.getName(), p.getDisplayName(), p.getDbType(), p.getReferenceToName()));
        }
        if (det.getProperties().getCollectionProperties() != null && !det.getProperties().getCollectionProperties().isEmpty()) {
            System.out.println("  Collection Properties:");
            det.getProperties().getCollectionProperties().forEach(p -> System.out.printf("    - %s: Item Type = %s%n", p.getName(), p.getItemDataEntityTypeName()));
        }
        if (det.getDataEntityIndexes() != null && !det.getDataEntityIndexes().isEmpty()) {
            System.out.println("  Data Entity Indexes:");
            det.getDataEntityIndexes().forEach(idx -> System.out.printf("    - %s: Unique = %b, Properties = %s%n", idx.getName(), idx.isUnique(), idx.getRelatedProperties()));
        }
        if (det.getInterfaceReferences() != null && !det.getInterfaceReferences().isEmpty()) {
            System.out.println("  Interface References:");
            det.getInterfaceReferences().forEach(ref -> System.out.printf("    - %s%n", ref.getName()));
        }
        System.out.println("----------------------------------------");
        System.out.println();
    }
}

