/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.utils;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DicProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DicPropertyUtil {
    public static Map<String, List<DicProperty>> parsePickListTypes(String path) {
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            System.err.println("\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u76ee\u5f55: " + path);
            return new HashMap<String, List<DicProperty>>();
        }
        File[] files = directory.listFiles((dir, name) -> name.startsWith("PickListType") && name.endsWith(".dcxml"));
        if (files == null || files.length == 0) {
            System.out.println("\u5728\u76ee\u5f55 " + path + " \u4e2d\u672a\u627e\u5230PickListType XML\u6587\u4ef6");
            return new HashMap<String, List<DicProperty>>();
        }
        System.out.println("\u627e\u5230 " + files.length + " \u4e2aPickListType\u6587\u4ef6");
        HashMap<String, List<DicProperty>> pickListTypeMap = new HashMap<String, List<DicProperty>>();
        for (File file : files) {
            try {
                DicPropertyUtil.parsePickListTypeFile(pickListTypeMap, file);
            }
            catch (Exception e) {
                System.err.println("\u89e3\u6790\u6587\u4ef6\u5931\u8d25: " + file.getName() + " - " + e.getMessage());
            }
        }
        System.out.println("\u6210\u529f\u89e3\u6790 " + pickListTypeMap.size() + " \u4e2aPickListType");
        return pickListTypeMap;
    }

    private static void parsePickListTypeFile(Map<String, List<DicProperty>> pickListTypeMap, File xmlFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        Element rootElement = document.getDocumentElement();
        String pickListTypeName = DicPropertyUtil.getElementText(rootElement, "Name");
        if (pickListTypeName == null || pickListTypeName.trim().isEmpty()) {
            throw new Exception("PickListType\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DicProperty> items = DicPropertyUtil.parsePickListItems(rootElement);
        pickListTypeMap.put(pickListTypeName, items);
    }

    private static List<DicProperty> parsePickListItems(Element rootElement) {
        ArrayList<DicProperty> items = new ArrayList<DicProperty>();
        Element itemsElement = DicPropertyUtil.getFirstChildElement(rootElement, "Items");
        if (itemsElement == null) {
            return items;
        }
        NodeList itemNodes = itemsElement.getElementsByTagName("PickListItem");
        for (int i = 0; i < itemNodes.getLength(); ++i) {
            Element itemElement = (Element)itemNodes.item(i);
            DicProperty item = new DicProperty();
            item.setId(DicPropertyUtil.getElementText(itemElement, "Id"));
            item.setDisplayName(DicPropertyUtil.getElementText(itemElement, "DisplayName"));
            String sequenceText = DicPropertyUtil.getElementText(itemElement, "Sequence");
            if (sequenceText != null && !sequenceText.trim().isEmpty()) {
                try {
                    item.setSequence(Integer.parseInt(sequenceText.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            items.add(item);
        }
        return items.stream().sorted(Comparator.comparingInt(DicProperty::getSequence)).collect(Collectors.toList());
    }

    public static List<DicProperty> getPickListItems(Map<String, List<DicProperty>> pickListTypeMap, String pickListTypeName) {
        return pickListTypeMap.getOrDefault(pickListTypeName, new ArrayList());
    }

    private static String getElementText(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            return node.getTextContent();
        }
        return null;
    }

    private static Element getFirstChildElement(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() > 0 && nodes.item(0).getNodeType() == 1) {
            return (Element)nodes.item(0);
        }
        return null;
    }
}

