/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist;

import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.picklist.dto.PickListType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PickListParser {
    public static List<PickListType> parser(List<String> xmlFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PickListType.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ArrayList<PickListType> list = new ArrayList<PickListType>();
            for (String file : xmlFile) {
                PickListType pickListType = (PickListType)unmarshaller.unmarshal(new File(file));
                list.add(pickListType);
            }
            return list;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        List<Path> filePathsWithPrefix = FileLister.getFilePathsWithPrefix("C:\\Users\\Alor\\Desktop\\\u65b0\u5efa\u6587\u4ef6\u5939\\E80KF-20251011092257\\Server\\Application\\BusinessObjects\\MetadataContainerElement", "PickListType.", 1);
        List<String> files = filePathsWithPrefix.stream().map(Path::toString).collect(Collectors.toList());
        List<PickListType> parser = PickListParser.parser(files);
    }
}

