/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.query;

import cn.hutool.core.lang.Tuple;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.MetadataParser;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DataProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.metadata.dto.DicProperty;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.constant.SqlParserConstant;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.SqlResult;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils.DateTimeUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils.SqlUtil;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils.StringBusinessUtil;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlParser {
    private E10Properties e10Properties;
    private final List<SqlResult> sqlResults = new ArrayList<SqlResult>();
    private final List<String> selectList = new ArrayList<String>();
    private final Set<String> orderByList = new HashSet<String>();
    private final List<String> fromList = new ArrayList<String>();
    private final List<String> returnFieldList = new ArrayList<String>();
    private final Set<String> relatedEntities = new HashSet<String>();
    private final Map<String, String> tableAliasMap = new HashMap<String, String>();
    private Map<String, DataEntity> metaDataEntityMap = new HashMap<String, DataEntity>();
    private Map<String, List<DicProperty>> dicPropertyMap = new HashMap<String, List<DicProperty>>();
    private final LinkedList<String> mainTableCache = new LinkedList();
    private final LinkedList<String> caseTableCache = new LinkedList();
    private int tableCounter = 1;
    private String caseWhenTableCache;
    private String inputMainTableColumnCache;
    private String caseInputCurrentTable;
    private String caseInputCurrentAlias;
    private String currentTable;
    private String currentAlias;
    private String currentFk;
    private final ThreadLocal<Map<String, String>> queryProjectContext = new ThreadLocal();

    public static void main(String[] args) {
        try {
            SqlParser sqlParser = new SqlParser();
            List<Path> pathList = FileLister.getFilePathsWithFileName(sqlParser.e10Properties.getQueryBusinessObjectsRoot(), "QueryProjectContainer.dcxml");
            for (Path p : pathList) {
                sqlParser.parseXmlToSql(p);
            }
            SqlUtil.validateSqlExecute(sqlParser.getSqlResults());
            SqlUtil.writeTxt(sqlParser.getSqlResults());
            SqlUtil.covertTxt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseXmlToSql(Path xmlFilePath) throws Exception {
        File xmlFile = xmlFilePath.toFile();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xmlFile);
        NodeList queryProjects = doc.getElementsByTagName("QueryProject");
        for (int i = 0; i < queryProjects.getLength(); ++i) {
            Element queryProject = (Element)queryProjects.item(i);
            String queryEntity = this.getElementText(queryProject, "QueryEntity");
            String id = this.getElementText(queryProject, "Id");
            String description = this.getElementText(queryProject, "Description");
            String queryPath = this.ignoreParse(xmlFile, id, queryEntity);
            if (queryPath == null) continue;
            this.parseQueryProjectWapper(queryProject, queryPath, description);
        }
    }

    private String ignoreParse(File xmlFile, String id, String queryEntity) {
        String[] queryIds;
        String queryPath = String.join((CharSequence)":", xmlFile.getParentFile().getName(), id);
        for (String queryId : queryIds = queryEntity.split("\\.")) {
            if (!SqlParserConstant.IGNORE_QUERY_LIST.contains(queryId)) continue;
            return null;
        }
        if (SqlParserConstant.IGNORE_QUERY_ID_LIST.contains(queryPath)) {
            return null;
        }
        return queryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseQueryProjectWapper(Element queryProject, String queryPath, String description) {
        String sql = "";
        try {
            this.resetData(queryPath);
            sql = this.parseQueryProject(queryProject);
            SqlResult result = SqlResult.builder().code(queryPath).businessCode(queryPath.split(":")[0]).sqlExample(sql).description(description).name(description).returnFields(String.join((CharSequence)",", this.returnFieldList)).build();
            this.sqlResults.add(result);
        }
        catch (Exception e) {
            String queryEntity = this.queryProjectContext.get().get("QueryEntity");
            String queryViewColumn = this.queryProjectContext.get().get("QueryViewColumn");
            String condition = this.queryProjectContext.get().get("Condition");
            System.err.println("----------------------------------------------------------------------------------------\n\u67e5\u8be2ID\uff1a" + queryPath + "\uff0c\u62a5\u9519\u7c7b\u578b\uff1a" + e.getMessage() + "\n\u539f\u59cbxml\u4fe1\u606f\uff1a\nQueryEntity\uff1a" + queryEntity + (String)(!StringUtils.hasText((String)queryViewColumn) ? "" : "\n" + queryViewColumn) + (String)(!StringUtils.hasText((String)condition) ? "" : "\n" + condition));
            SqlResult result = SqlResult.builder().code(queryPath).businessCode(queryPath.split(":")[0]).sqlExample(sql).description(description).name(description).error(e.getMessage()).returnFields(String.join((CharSequence)",", this.returnFieldList)).build();
            this.sqlResults.add(result);
        }
        finally {
            this.resetData(queryPath);
        }
    }

    private String parseQueryProject(Element queryProject) {
        Tuple mainTable = this.parseMainTable(queryProject);
        this.parseQueryViewColumns(queryProject, (String)mainTable.get(0), (String)mainTable.get(1));
        String whereClause = this.parseCondition(queryProject, (String)mainTable.get(0), (String)mainTable.get(1));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SqlParserConstant.NEW_LINE);
        if (CollectionUtils.isEmpty(this.selectList)) {
            sql.append(" * ");
        } else {
            sql.append(String.join((CharSequence)(", " + SqlParserConstant.NEW_LINE), this.selectList));
        }
        sql.append(SqlParserConstant.NEW_LINE);
        sql.append("FROM ");
        sql.append(String.join((CharSequence)(" " + SqlParserConstant.NEW_LINE), this.fromList));
        if (!whereClause.isEmpty()) {
            sql.append(SqlParserConstant.NEW_LINE);
            sql.append("WHERE ").append(whereClause);
        }
        if (!this.orderByList.isEmpty()) {
            sql.append(SqlParserConstant.NEW_LINE);
            sql.append("ORDER BY");
            sql.append(SqlParserConstant.NEW_LINE);
            sql.append(String.join((CharSequence)(", " + SqlParserConstant.NEW_LINE), this.orderByList));
        }
        return sql.toString();
    }

    private Tuple parseMainTable(Element queryProject) {
        String mainTable = this.getElementText(queryProject, "QueryEntity");
        String mainTableAlias = "t0";
        this.setQueryEntityContext(mainTable);
        String[] split = mainTable.split("\\.");
        String currentTable = null;
        for (String table : split) {
            if (null == currentTable) {
                this.mainTableCache.addFirst(table);
                currentTable = table;
                continue;
            }
            Tuple tuple = MetadataParser.queryReference(this.metaDataEntityMap, currentTable, table);
            if (tuple == null) {
                throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e22\u5931\u5c5e\u6027\uff1a" + currentTable + "." + table + ",QueryEntity\u503c\uff1a" + mainTable);
            }
            this.mainTableCache.addFirst((String)tuple.get(0));
            currentTable = (String)tuple.get(0);
        }
        currentTable = null;
        Object currentAlias = null;
        for (String s : this.mainTableCache) {
            if (null == currentTable) {
                mainTable = s;
                currentAlias = mainTableAlias;
                currentTable = s;
                String joins = "[" + mainTable + "] AS [" + mainTableAlias + "]";
                if (this.tableAliasMap.containsKey(joins)) continue;
                this.fromList.add(joins);
                this.tableAliasMap.put(joins, mainTableAlias);
                continue;
            }
            Tuple tuple = MetadataParser.queryReferenceByTable(this.metaDataEntityMap, s, currentTable);
            if (tuple != null) {
                String joinKey = String.format("LEFT JOIN [%s] AS [] ON [%s].[%s] = [%s].[%s]", s, currentAlias, tuple.get(1), s, tuple.get(1));
                if (this.tableAliasMap.containsKey(joinKey)) continue;
                String newAlias = "t" + this.tableCounter++;
                String joins = "LEFT JOIN [" + s + "] AS [" + newAlias + "] ON [" + (String)currentAlias + "].[" + String.valueOf(tuple.get(1)) + "] = [" + newAlias + "].[" + String.valueOf(tuple.get(1)) + "]";
                this.fromList.add(joins);
                this.tableAliasMap.put(joinKey, newAlias);
                currentAlias = newAlias;
                currentTable = s;
                continue;
            }
            Tuple current = MetadataParser.queryPkByTableName(this.metaDataEntityMap, currentTable);
            String joinKey = String.format("LEFT JOIN [%s] AS [] ON [%s].[%s] = [%s].[%s]", s, currentAlias, current.get(1), s, current.get(1));
            if (this.tableAliasMap.containsKey(joinKey)) continue;
            String newAlias = "t" + this.tableCounter++;
            String joins = "LEFT JOIN [" + s + "] AS [" + newAlias + "] ON [" + (String)currentAlias + "].[" + String.valueOf(current.get(1)) + "] = [" + newAlias + "].[" + String.valueOf(current.get(1)) + "]";
            this.fromList.add(joins);
            this.tableAliasMap.put(joinKey, newAlias);
            currentAlias = newAlias;
            currentTable = s;
        }
        return new Tuple(new Object[]{mainTable, mainTableAlias});
    }

    private String transformer(Element column) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(column), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            return "";
        }
    }

    private void parseQueryViewColumns(Element queryProject, String mainTable, String mainTableAlias) {
        NodeList columns = queryProject.getElementsByTagName("QueryViewColumn");
        for (int i = 0; i < columns.getLength(); ++i) {
            String columnExpression;
            Element column = (Element)columns.item(i);
            this.setQueryViewColumnContext(column);
            String alias = this.getElementText(column, "Alias");
            String displayName = this.getElementText(column, "DisplayName");
            Element columnData = this.getFirstChildElement(column, "Column");
            String sort = this.getElementText(column, "Sort");
            String customFormat = this.getElementText(column, "CustomFormat");
            String customFormatIsExpression = this.getElementText(column, "CustomFormatIsExpression");
            if (StringUtils.hasText((String)customFormat)) {
                // empty if block
            }
            if (columnData == null || (columnExpression = this.parseColumnExpression(columnData, mainTable, mainTableAlias, alias)) == null || columnExpression.isEmpty()) continue;
            Element editorData = this.getFirstChildElement(column, "Editor");
            if (editorData != null) {
                Element dateTime;
                Element pickListLookUp = this.getFirstChildElement(editorData, "PickListLookUp");
                if (pickListLookUp != null) {
                    columnExpression = this.parsePickListCaseExpression(editorData, columnExpression);
                }
                if ((dateTime = this.getFirstChildElement(editorData, "DateTime")) != null) {
                    columnExpression = this.parseDateTimeExpression(editorData, columnExpression);
                }
            }
            this.selectList.add(columnExpression);
            this.returnFieldList.add(displayName);
            if (!StringUtils.hasText((String)sort) || !"DESC".equalsIgnoreCase(sort) && !"ASC".equalsIgnoreCase(sort)) continue;
            String order = SqlUtil.removeAsClause(columnExpression) + " " + sort.toUpperCase();
            this.orderByList.add(order);
        }
    }

    private String parseDateTimeExpression(Element editorData, String columnExpression) {
        StringBuilder caseExpr = new StringBuilder();
        return caseExpr.append(columnExpression).toString();
    }

    private String parsePickListCaseExpression(Element editorData, String columnExpression) {
        Element pickListLookUp = this.getFirstChildElement(editorData, "PickListLookUp");
        StringBuilder caseExpr = new StringBuilder();
        if (pickListLookUp != null) {
            String pickListTypeName = this.getElementText(pickListLookUp, "PickListTypeName");
            List pickList = this.dicPropertyMap.getOrDefault(pickListTypeName, new ArrayList());
            if (CollectionUtils.isEmpty((Collection)pickList)) {
                caseExpr.append(columnExpression);
            } else {
                String[] parts = columnExpression.split(" AS ", 2);
                caseExpr.append("CASE").append(" ").append(parts[0]);
                for (DicProperty item : pickList) {
                    caseExpr.append(SqlParserConstant.NEW_LINE).append(" ").append("WHEN N'").append(item.getId()).append("' THEN '").append(item.getDisplayName()).append("'");
                }
                caseExpr.append(SqlParserConstant.NEW_LINE).append(" ").append("END");
                caseExpr.append(" AS ").append(parts[1]);
            }
            return caseExpr.toString();
        }
        return caseExpr.append(columnExpression).toString();
    }

    private String parseColumnExpression(Element columnElement, String mainTable, String mainTableAlias, String alias) {
        Element propertyValue = this.getFirstChildElement(columnElement, "PropertyValue");
        if (propertyValue != null) {
            return this.parsePropertyValue(propertyValue, mainTable, mainTableAlias, alias, true);
        }
        Element constantValue = this.getFirstChildElement(columnElement, "ConstantValue");
        if (constantValue != null) {
            String value = this.parseExpressionConstantValue(constantValue);
            return value + " AS [" + alias + "]";
        }
        Element caseValue = this.getFirstChildElement(columnElement, "CaseValue");
        if (caseValue != null) {
            return this.parseCaseValueWapper(caseValue, mainTable, mainTableAlias, alias);
        }
        Element expressionValue = this.getFirstChildElement(columnElement, "ExpressionValue");
        if (expressionValue != null) {
            String expression = this.parseExpressionValue(expressionValue, mainTable, mainTableAlias);
            return expression + " AS [" + alias + "]";
        }
        return null;
    }

    private String parsePropertyValue(Element propertyValue, String mainTable, String mainTableAlias, String alias, boolean isJoin) {
        Element caseValueElement;
        String path = this.getElementText(propertyValue, "Path");
        if (path == null) {
            return null;
        }
        if (path.matches(".*\\.ROid\\([^)]+\\)\\..*") && (caseValueElement = this.convertRoidPathToCaseValue(propertyValue, path)) != null) {
            return this.parseCaseValueWapper(caseValueElement, mainTable, mainTableAlias, alias);
        }
        Tuple table = this.resolveTableJoin(path, mainTable, mainTableAlias);
        if (isJoin && table.size() > 2) {
            String column = SqlParser.getCovertColumn(path, table);
            return "[" + String.valueOf(table.get(0)) + "].[" + column + "] AS [" + alias + "]";
        }
        return "[" + String.valueOf(table.get(0)) + "].[" + String.valueOf(table.get(1)) + "] AS [" + alias + "]";
    }

    private Element convertRoidPathToCaseValue(Element originalPropertyValue, String path) {
        try {
            String[] parts = path.split("\\.ROid\\(");
            if (parts.length != 2) {
                return null;
            }
            String basePath = parts[0];
            String rest = parts[1];
            String[] restParts = rest.split("\\)\\.");
            if (restParts.length != 2) {
                return null;
            }
            String entityType = restParts[0];
            String fieldName = restParts[1];
            Document doc = originalPropertyValue.getOwnerDocument();
            Element caseValue = doc.createElement("CaseValue");
            Element caseInput = doc.createElement("CaseInput");
            Element inputProperty = doc.createElement("PropertyValue");
            Element inputId = doc.createElement("Id");
            inputId.setTextContent(UUID.randomUUID().toString());
            Element inputPath = doc.createElement("Path");
            inputPath.setTextContent(basePath);
            inputProperty.appendChild(inputId);
            inputProperty.appendChild(inputPath);
            caseInput.appendChild(inputProperty);
            caseValue.appendChild(caseInput);
            Element caseBranches = doc.createElement("CaseBranches");
            Element caseBranch = doc.createElement("CaseBranch");
            Element caseWhen = doc.createElement("CaseWhen");
            Element whenConstant = doc.createElement("ConstantValue");
            Element whenId = doc.createElement("Id");
            whenId.setTextContent(UUID.randomUUID().toString());
            Element whenValue = doc.createElement("Value");
            whenValue.setTextContent(entityType);
            whenConstant.appendChild(whenId);
            whenConstant.appendChild(whenValue);
            caseWhen.appendChild(whenConstant);
            caseBranch.appendChild(caseWhen);
            Element caseThen = doc.createElement("CaseThen");
            Element thenProperty = doc.createElement("PropertyValue");
            Element thenId = doc.createElement("Id");
            thenId.setTextContent(UUID.randomUUID().toString());
            Element thenPath = doc.createElement("Path");
            thenPath.setTextContent(fieldName);
            thenProperty.appendChild(thenId);
            thenProperty.appendChild(thenPath);
            caseThen.appendChild(thenProperty);
            caseBranch.appendChild(caseThen);
            caseBranches.appendChild(caseBranch);
            caseValue.appendChild(caseBranches);
            return caseValue;
        }
        catch (Exception e) {
            System.err.println("\u8f6c\u6362 ROid \u8def\u5f84\u5931\u8d25: " + path + ", \u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    private Tuple resolveTableJoin(String tablePath, String mainTable, String mainTableAlias) {
        if (this.caseWhenTableCache != null) {
            tablePath = String.join((CharSequence)".", this.caseWhenTableCache, tablePath);
        }
        this.currentAlias = mainTableAlias;
        this.currentTable = mainTable;
        ArrayList<String> tableList = new ArrayList<String>(Arrays.asList(StringBusinessUtil.splitString(tablePath)));
        String resultColumn = "";
        int i = 0;
        while (i < tableList.size()) {
            String tableName = (String)tableList.get(i);
            Tuple tuple = MetadataParser.queryReferToEntity(this.metaDataEntityMap, this.currentTable, tableName);
            if (tuple != null) {
                this.caseInputCurrentTable = this.currentTable;
                this.caseInputCurrentAlias = this.currentAlias;
                this.inputMainTableColumnCache = (String)tuple.get(1);
                return new Tuple(new Object[]{this.currentAlias, tuple.get(0), tuple.get(1)});
            }
            if (i == tableList.size() - 1) {
                String queryColumnName = MetadataParser.queryColumnName(this.metaDataEntityMap, this.currentTable, tableName);
                resultColumn = StringUtils.isEmpty((Object)queryColumnName) ? tableName : queryColumnName;
                ++i;
                continue;
            }
            if (i == 0 && tableName.equals(mainTable)) {
                ++i;
                continue;
            }
            if (tableName.contains("Parent")) {
                String[] childTables = tableName.split("\\.");
                if (childTables[0].equals("Parent")) {
                    String tempTableName = this.currentTable;
                    tableList.remove(i);
                    for (int j = 0; j < childTables.length; ++j) {
                        String childTable = childTables[j];
                        if (!"Parent".equals(childTable)) continue;
                        tempTableName = StringBusinessUtil.getParent(this.mainTableCache, tempTableName);
                        tableList.add(i + j, tempTableName);
                    }
                    continue;
                }
                String afterFirstDot = StringBusinessUtil.getAfterFirstDot(tableName);
                Tuple parentTuple = MetadataParser.queryReference(this.metaDataEntityMap, this.currentTable, childTables[0], afterFirstDot);
                if (parentTuple == null || parentTuple.get(0).equals(childTables[0])) {
                    String tempTableName = childTables[0];
                    tableList.remove(i);
                    for (int j = 0; j < childTables.length; ++j) {
                        String childTable = childTables[j];
                        if (!"Parent".equals(childTable) || CollectionUtils.isEmpty(this.caseTableCache)) continue;
                        tempTableName = StringBusinessUtil.getParent(this.caseTableCache, tempTableName);
                        tableList.add(i + j, tempTableName);
                    }
                    continue;
                }
                String resolvedTablePath = StringBusinessUtil.reverseDotSeparated((String)parentTuple.get(0));
                if (resolvedTablePath.contains(".")) {
                    int length = afterFirstDot.split("\\.").length;
                    tableList.remove(i);
                    String[] resolvedTables = resolvedTablePath.split("\\.");
                    for (int j = 0; j < resolvedTables.length; ++j) {
                        if (j > length) continue;
                        tableList.add(i + j, resolvedTables[j]);
                    }
                    this.currentFk = childTables[0];
                    continue;
                }
                tableList.set(i, resolvedTablePath);
                continue;
            }
            Tuple checkTable = MetadataParser.queryPkByTableName(this.metaDataEntityMap, tableName);
            if (checkTable == null) {
                this.processFieldJoin(tableName, this.currentTable, this.currentAlias);
            } else {
                this.processTableJoin(tableName, checkTable, this.currentAlias);
            }
            this.currentFk = null;
            ++i;
        }
        return new Tuple(new Object[]{this.currentAlias, resultColumn});
    }

    private void processFieldJoin(String fieldName, String currentTable, String currentAlias) {
        Tuple reference = MetadataParser.queryReference(this.metaDataEntityMap, currentTable, fieldName);
        if (reference == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e22\u5931\u5c5e\u6027\uff1a" + currentTable + "." + fieldName);
        }
        String targetTable = (String)reference.get(0);
        String targetField = (String)reference.get(1);
        this.createJoin(currentAlias, fieldName, targetTable, targetField);
    }

    private void processTableJoin(String tableName, Tuple tableInfo, String currentAlias) {
        Tuple queryReferenceByTable = MetadataParser.queryReferenceByTable(this.metaDataEntityMap, this.currentTable, tableName);
        if (queryReferenceByTable != null) {
            tableInfo = new Tuple(new Object[]{tableInfo.get(0), queryReferenceByTable.get(1)});
        }
        String targetTable = (String)tableInfo.get(0);
        String primaryKey = (String)tableInfo.get(1);
        String mainPk = (String)tableInfo.get(1);
        if (this.currentFk != null) {
            mainPk = this.currentFk;
        }
        this.createJoin(currentAlias, mainPk, targetTable, primaryKey);
    }

    private void createJoin(String currentAlias, String sourceField, String targetTable, String targetField) {
        String joinKey;
        if (this.inputMainTableColumnCache != null && this.caseWhenTableCache != null) {
            sourceField = this.inputMainTableColumnCache;
            currentAlias = this.caseInputCurrentAlias;
        }
        if (!this.tableAliasMap.containsKey(joinKey = String.format("LEFT JOIN [%s] AS [] ON [%s].[%s] = [%s].[%s]", targetTable, currentAlias, sourceField, targetTable, targetField))) {
            String newAlias = "t" + this.tableCounter++;
            String joinSql = String.format("LEFT JOIN [%s] AS [%s] ON [%s].[%s] = [%s].[%s]", targetTable, newAlias, currentAlias, sourceField, newAlias, targetField);
            this.fromList.add(joinSql);
            this.tableAliasMap.put(joinKey, newAlias);
            this.currentTable = targetTable;
            this.currentAlias = newAlias;
        } else {
            this.currentTable = targetTable;
            this.currentAlias = this.tableAliasMap.get(joinKey);
        }
    }

    private String parseCaseValue(Element caseValue, String mainTable, String mainTableAlias, String alias) {
        Element caseElse;
        Element caseBranches;
        StringBuilder caseBuilder = new StringBuilder("CASE ");
        Element caseInput = this.getFirstChildElement(caseValue, "CaseInput");
        if (caseInput != null) {
            caseBuilder.append(this.parseExpression(caseInput, mainTable, mainTableAlias)).append(SqlParserConstant.NEW_LINE);
        }
        if ((caseBranches = this.getFirstChildElement(caseValue, "CaseBranches")) != null) {
            NodeList branches = caseBranches.getElementsByTagName("CaseBranch");
            for (int i = 0; i < branches.getLength(); ++i) {
                Element branch = (Element)branches.item(i);
                caseBuilder.append(this.parseCaseBranchWapper(branch, mainTable, mainTableAlias));
            }
        }
        if ((caseElse = this.getFirstChildElement(caseValue, "CaseElse")) != null) {
            caseBuilder.append(" ELSE ").append(this.parseExpression(caseElse, mainTable, mainTableAlias)).append(SqlParserConstant.NEW_LINE);
        }
        caseBuilder.append(" END");
        if (alias != null) {
            caseBuilder.append(" AS [").append(alias).append("]");
        }
        return caseBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseCaseValueWapper(Element caseValue, String mainTable, String mainTableAlias, String alias) {
        try {
            this.inputMainTableColumnCache = null;
            String string = this.parseCaseValue(caseValue, mainTable, mainTableAlias, alias);
            return string;
        }
        finally {
            this.inputMainTableColumnCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseCaseBranchWapper(Element caseBranch, String mainTable, String mainTableAlias) {
        try {
            this.caseWhenTableCache = null;
            this.caseTableCache.clear();
            String string = this.parseCaseBranch(caseBranch, mainTable, mainTableAlias);
            return string;
        }
        finally {
            this.caseWhenTableCache = null;
            this.caseTableCache.clear();
        }
    }

    private String parseCaseBranch(Element caseBranch, String mainTable, String mainTableAlias) {
        Element caseThen;
        Element propertyValue;
        StringBuilder branchBuilder = new StringBuilder(" WHEN ");
        Element caseWhen = this.getFirstChildElement(caseBranch, "CaseWhen");
        if (caseWhen != null) {
            Element constantValue = this.getFirstChildElement(caseWhen, "ConstantValue");
            if (constantValue != null) {
                String[] split;
                Tuple tuple;
                String value = this.getElementText(constantValue, "Value");
                if (value == null) {
                    value = "";
                }
                if ((tuple = MetadataParser.queryPkByTableName(this.metaDataEntityMap, (split = value.split("\\."))[0])) != null) {
                    String currentTable = null;
                    for (String table : split) {
                        if (null == currentTable) {
                            this.caseTableCache.addFirst(table);
                            currentTable = table;
                        } else {
                            tuple = MetadataParser.queryReference(this.metaDataEntityMap, currentTable, table);
                            this.caseTableCache.addFirst((String)tuple.get(0));
                            currentTable = (String)tuple.get(0);
                        }
                        this.caseWhenTableCache = currentTable;
                    }
                } else if (this.inputMainTableColumnCache != null) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u7f3a\u5931\uff1a" + split[0]);
                }
                branchBuilder.append("N'").append(value).append("' ");
            }
            if ((propertyValue = this.getFirstChildElement(caseWhen, "PropertyValue")) != null) {
                String value = this.getElementText(propertyValue, "Path");
                branchBuilder.append("N'").append(value).append("' ");
            }
        }
        if ((caseThen = this.getFirstChildElement(caseBranch, "CaseThen")) != null) {
            propertyValue = this.getFirstChildElement(caseThen, "PropertyValue");
            if (propertyValue != null) {
                String path = this.getElementText(propertyValue, "Path");
                path = StringUtils.hasText((String)path) ? path : "";
                String[] paths = path.split("\\.");
                Tuple tuple = MetadataParser.queryPkByTableName(this.metaDataEntityMap, path = paths[paths.length - 1]);
                if (tuple != null) {
                    return branchBuilder.append("THEN '").append(path).append("' ").append(SqlParserConstant.NEW_LINE).toString();
                }
            }
            branchBuilder.append("THEN ").append(this.parseExpression(caseThen, mainTable, mainTableAlias)).append(SqlParserConstant.NEW_LINE);
        }
        return branchBuilder.toString();
    }

    private String parseExpression(Element element, String mainTable, String mainTableAlias) {
        Element propertyValue = this.getFirstChildElement(element, "PropertyValue");
        if (propertyValue != null) {
            return this.parseExpressionPropertyValue(mainTable, mainTableAlias, propertyValue);
        }
        Element constantValue = this.getFirstChildElement(element, "ConstantValue");
        if (constantValue != null) {
            return this.parseExpressionConstantValue(constantValue);
        }
        Element functionValue = this.getFirstChildElement(element, "FunctionValue");
        if (functionValue != null) {
            return this.parseFunctionValue(functionValue, mainTable, mainTableAlias);
        }
        Element expressionValue = this.getFirstChildElement(element, "ExpressionValue");
        if (expressionValue != null) {
            return this.parseExpressionValue(expressionValue, mainTable, mainTableAlias);
        }
        Element caseValue = this.getFirstChildElement(element, "CaseValue");
        if (caseValue != null) {
            return this.parseCaseValueWapper(caseValue, mainTable, mainTableAlias, null);
        }
        Element parameterValue = this.getFirstChildElement(element, "ParameterValue");
        if (parameterValue != null) {
            return this.parseConditionExpressionParameterValue(parameterValue);
        }
        return "''";
    }

    private String parseExpressionConstantValue(Element constantValue, boolean useOriginalValue, boolean useConvertType) {
        boolean isNumeric;
        String value = this.getElementText(constantValue, "Value");
        String dataType = this.getElementText(constantValue, "DataType");
        String string = dataType = dataType == null ? "" : dataType;
        if (value == null || value.isEmpty()) {
            return "Guid".equals(dataType) ? "'00000000-0000-0000-0000-000000000000'" : "''";
        }
        boolean bl = isNumeric = ("Int32".equals(dataType) || "Decimal".equals(dataType)) && StringBusinessUtil.isNumeric(value);
        if (useOriginalValue) {
            return useConvertType ? SqlParserConstant.DATA_TYPE.getOrDefault(value, value) : (isNumeric ? value : "'" + value + "'");
        }
        return isNumeric ? value : "N'" + value + "'";
    }

    private String parseExpressionConstantValue(Element constantValue) {
        return this.parseExpressionConstantValue(constantValue, false, false);
    }

    private String parseExpressionPropertyValue(String mainTable, String mainTableAlias, Element propertyValue, boolean isJoin) {
        String path = this.getElementText(propertyValue, "Path");
        Tuple table = this.resolveTableJoin(path, mainTable, mainTableAlias);
        if (isJoin && table.size() > 2) {
            String column = SqlParser.getCovertColumn(path, table);
            return "[" + String.valueOf(table.get(0)) + "].[" + column + "]";
        }
        return "[" + String.valueOf(table.get(0)) + "].[" + String.valueOf(table.get(1)) + "]";
    }

    private static String getCovertColumn(String path, Tuple table) {
        String lastTwoPositionsOptimized = StringBusinessUtil.getLastTwoPositionsOptimized(path);
        String replace = lastTwoPositionsOptimized.replace(".", "_");
        String column = (String)table.get(2);
        if (replace.equals(table.get(2))) {
            column = (String)table.get(2);
        } else if (replace.equals(table.get(1))) {
            column = (String)table.get(1);
        }
        return column;
    }

    private String parseExpressionPropertyValue(String mainTable, String mainTableAlias, Element propertyValue) {
        return this.parseExpressionPropertyValue(mainTable, mainTableAlias, propertyValue, false);
    }

    private String parseFunctionValue(Element functionValue, String mainTable, String mainTableAlias) {
        String functionType = this.getElementText(functionValue, "FunctionType");
        if ("Cast".equals(functionType)) {
            NodeList parameters = functionValue.getElementsByTagName("Parameters");
            if (parameters.getLength() > 0) {
                Element params = (Element)parameters.item(0);
                NodeList children = params.getChildNodes();
                String expression = "";
                String dataType = "Int32";
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (!(node instanceof Element)) continue;
                    Element child = (Element)node;
                    if ("PropertyValue".equals(child.getTagName())) {
                        expression = this.parseExpressionPropertyValue(mainTable, mainTableAlias, child);
                        continue;
                    }
                    if ("ConstantValue".equals(child.getTagName())) {
                        dataType = this.parseExpressionConstantValue(child, true, true);
                        continue;
                    }
                    if (!"FunctionValue".equals(child.getTagName())) continue;
                    System.err.println("[WARN]\u672a\u77e5\u89e3\u6790Function\u5d4c\u5957Function:" + this.queryProjectContext.get().get("ID"));
                }
                return "CAST(" + expression + " AS " + dataType + ")";
            }
        } else if ("SubString".equals(functionType)) {
            NodeList parameters = functionValue.getElementsByTagName("Parameters");
            if (parameters.getLength() > 0) {
                Element params = (Element)parameters.item(0);
                NodeList children = params.getChildNodes();
                String param = "";
                StringBuilder str = new StringBuilder("SUBSTRING( ");
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (!(node instanceof Element)) continue;
                    Element child = (Element)node;
                    if ("PropertyValue".equals(child.getTagName())) {
                        param = this.parseExpressionPropertyValue(mainTable, mainTableAlias, child);
                        str.append(param).append(", ");
                        continue;
                    }
                    if ("ConstantValue".equals(child.getTagName())) {
                        param = this.parseExpressionConstantValue(child, true, true);
                        str.append(param).append(", ");
                        continue;
                    }
                    if (!"FunctionValue".equals(child.getTagName())) continue;
                    param = this.parseFunctionValue(child, mainTable, mainTableAlias);
                    str.append(param).append(", ");
                }
                return str.toString().replaceAll(",(?!.*,)", ")");
            }
        } else {
            throw new IllegalArgumentException("\u4e0d\u80fd\u89e3\u6790\u8be5\u8868\u8fbe\u5f0f " + functionType);
        }
        return "";
    }

    private String parseExpressionValue(Element expressionValue, String mainTable, String mainTableAlias) {
        String operator = this.getElementText(expressionValue, "Operator");
        Element left = this.getFirstChildElement(expressionValue, "Left");
        Element right = this.getFirstChildElement(expressionValue, "Right");
        String leftExpr = left != null ? this.parseExpression(left, mainTable, mainTableAlias) : "";
        String rightExpr = right != null ? this.parseExpression(right, mainTable, mainTableAlias) : "";
        String opSymbol = "";
        switch (operator) {
            case "Plus": {
                opSymbol = "+";
                break;
            }
            case "Sub": {
                opSymbol = "-";
                break;
            }
            case "Mul": {
                opSymbol = "*";
                break;
            }
            case "Mulit": {
                opSymbol = "*";
                break;
            }
            case "Div": {
                opSymbol = "/";
                break;
            }
            case "Join": {
                opSymbol = "+";
                return "(CONCAT(" + leftExpr + "," + rightExpr + "))";
            }
            default: {
                System.out.println("[WARN]ExpressionValue\u7279\u6b8a\u64cd\u4f5c\u7b26\u53f7:" + operator);
                opSymbol = operator;
            }
        }
        return "(" + leftExpr + " " + opSymbol + " " + rightExpr + ")";
    }

    private String parseCondition(Element queryProject, String mainTable, String mainTableAlias) {
        Element condition = this.getFirstChildElement(queryProject, "Condition");
        this.setConditionContext(condition);
        if (condition != null) {
            Element conditionGroup = this.getFirstChildElement(condition, "ConditionItemGroup");
            if (conditionGroup != null) {
                return this.parseConditionItemGroup(conditionGroup, mainTable, mainTableAlias);
            }
            Element conditionItem = this.getFirstChildElement(condition, "ConditionItem");
            if (conditionItem != null) {
                return this.parseConditionItem(conditionItem, mainTable, mainTableAlias);
            }
        }
        return "";
    }

    private String parseConditionItemGroup(Element group, String mainTable, String mainTableAlias) {
        String logicalOperator;
        StringBuilder groupBuilder = new StringBuilder("(");
        ArrayList<String> items = new ArrayList<String>();
        Element itemsElement = this.getFirstChildElement(group, "Items");
        if (itemsElement != null) {
            NodeList children = itemsElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String tagName = childElement.getTagName();
                if ("ConditionItemGroup".equals(tagName)) {
                    items.add(this.parseConditionItemGroup(childElement, mainTable, mainTableAlias));
                    continue;
                }
                if (!"ConditionItem".equals(tagName)) continue;
                items.add(this.parseConditionItem(childElement, mainTable, mainTableAlias));
            }
        }
        if ((logicalOperator = this.getElementText(group, "LogicalOperator")) == null || logicalOperator.isEmpty()) {
            logicalOperator = "And";
        }
        if (!items.isEmpty()) {
            groupBuilder.append(String.join((CharSequence)(" " + SqlParserConstant.LOGICAL_OPERATORS.get(logicalOperator) + " "), items));
        } else {
            groupBuilder.append("1=1");
        }
        groupBuilder.append(")");
        return groupBuilder.toString();
    }

    private String parseConditionItem(Element conditionItem, String mainTable, String mainTableAlias) {
        String compareOperator = this.getElementText(conditionItem, "CompareOperator");
        Element left = this.getFirstChildElement(conditionItem, "Left");
        Element values = this.getFirstChildElement(conditionItem, "Values");
        String operatorSymbol = SqlParserConstant.COMPARE_OPERATORS.getOrDefault(compareOperator, compareOperator);
        String leftExpression = this.parseConditionExpression(left, mainTable, mainTableAlias);
        if ("IsNull".equals(compareOperator)) {
            return leftExpression + " IS NULL";
        }
        if ("IsNotNull".equals(compareOperator)) {
            return leftExpression + " IS NOT NULL";
        }
        String rightExpression = this.parseConditionValues(operatorSymbol, values, mainTable, mainTableAlias);
        if ("In".equals(compareOperator)) {
            return leftExpression + " IN (" + rightExpression + ")";
        }
        if ("NotIn".equals(compareOperator)) {
            return leftExpression + " NOT IN (" + rightExpression + ")";
        }
        return leftExpression + " " + operatorSymbol + " " + rightExpression;
    }

    private String parseConditionExpression(Element element, String mainTable, String mainTableAlias) {
        if (element == null) {
            return "";
        }
        Element propertyValue = this.getFirstChildElement(element, "PropertyValue");
        if (propertyValue != null) {
            return this.parseExpressionPropertyValue(mainTable, mainTableAlias, propertyValue, true);
        }
        Element parameterValue = this.getFirstChildElement(element, "ParameterValue");
        if (parameterValue != null) {
            return this.parseConditionExpressionParameterValue(parameterValue);
        }
        Element dyncParameterValue = this.getFirstChildElement(element, "DyncParameterValue");
        if (dyncParameterValue != null) {
            return this.parseConditionExpressionParameterValue(dyncParameterValue);
        }
        Element caseValue = this.getFirstChildElement(element, "CaseValue");
        if (caseValue != null) {
            return this.parseCaseValueWapper(caseValue, mainTable, mainTableAlias, null);
        }
        Element functionValue = this.getFirstChildElement(element, "FunctionValue");
        if (functionValue != null) {
            return this.parseFunctionValue(functionValue, mainTable, mainTableAlias);
        }
        Element expressionValue = this.getFirstChildElement(element, "ExpressionValue");
        if (expressionValue != null) {
            return this.parseExpressionValue(expressionValue, mainTable, mainTableAlias);
        }
        Element constantValue = this.getFirstChildElement(element, "ConstantValue");
        if (constantValue != null) {
            return this.parseExpressionConstantValue(constantValue, true, false);
        }
        return "";
    }

    private String parseConditionExpressionParameterValue(Element parameterValue) {
        String paramName = this.getElementText(parameterValue, "ParameterName");
        return String.format("'@%s'", paramName);
    }

    private String parseConditionExpressionLambdaValue(Element parameterValue) {
        String dataType = this.getElementText(parameterValue, "DataType");
        dataType = dataType == null ? "" : dataType;
        String expression = this.getElementText(parameterValue, "Expression");
        if (expression.equals("Context.NowDate") && dataType.equals("Date")) {
            expression = DateTimeUtil.getCurrentDate();
        } else if (expression.equals("Context.ServerDate()") && dataType.equals("DateTime")) {
            expression = DateTimeUtil.getCurrentDateTime();
        } else if (expression.equals("GuidDefaultValue()") && dataType.equals("Guid")) {
            expression = "00000000-0000-0000-0000-000000000000";
        } else if (expression.equals("'1900-01-01 00:00:00.0000000'") && dataType.equals("DateTime")) {
            expression = "1900-01-01 00:00:00.0000000";
        } else if (expression.equals("Context.System_Time") && dataType.equals("DateTime")) {
            expression = DateTimeUtil.getCurrentDateTime();
        } else {
            throw new IllegalArgumentException("\u6ca1\u6709\u89e3\u6790\u7684Lambda\u8868\u8fbe\u5f0fdataType:" + dataType + "   expression:" + expression);
        }
        return "'" + expression + "'";
    }

    private String parseConditionExpressionVariableValue(Element parameterValue) {
        String dataType = this.getElementText(parameterValue, "DataType");
        dataType = dataType == null ? "" : dataType;
        String expression = this.getElementText(parameterValue, "VariableExpression");
        if (expression.equals("@Today") && (dataType.equals("Date") || dataType.equals("DATE"))) {
            expression = DateTimeUtil.getCurrentDate();
        } else if (expression.equals("@ThisMonth") && (dataType.equals("Date") || dataType.equals("DATE"))) {
            expression = DateTimeUtil.getCurrentYearMonth();
        } else if (expression.equals("@ThisWeek") && (dataType.equals("Date") || dataType.equals("DATE"))) {
            expression = DateTimeUtil.getDayOfWeekCN(LocalDate.now());
        } else {
            System.out.println("\u6ca1\u6709\u89e3\u6790\u7684Variable\u8868\u8fbe\u5f0fdataType:" + dataType + "   expression:" + expression);
        }
        return "'" + expression + "'";
    }

    private String parseConditionValues(String operatorSymbol, Element values, String mainTable, String mainTableAlias) {
        if (values == null) {
            return "";
        }
        ArrayList<String> valueList = new ArrayList<String>();
        NodeList children = values.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String value = "";
            if ("PropertyValue".equals(child.getTagName())) {
                value = this.parseExpressionPropertyValue(mainTable, mainTableAlias, child);
            } else if ("FunctionValue".equals(child.getTagName())) {
                value = this.parseFunctionValue(child, mainTable, mainTableAlias);
            } else if ("ExpressionValue".equals(child.getTagName())) {
                value = this.parseExpressionValue(child, mainTable, mainTableAlias);
            } else if ("CaseValue".equals(child.getTagName())) {
                value = this.parseCaseValueWapper(child, mainTable, mainTableAlias, null);
            } else if ("ParameterValue".equals(child.getTagName()) || "DyncParameterValue".equals(child.getTagName())) {
                value = this.parseConditionExpressionParameterValue(child);
            } else if ("ConstantValue".equals(child.getTagName())) {
                value = this.parseExpressionConstantValue(child, true, false);
            } else if ("LambdaValue".equals(child.getTagName())) {
                value = this.parseConditionExpressionLambdaValue(child);
            } else if ("VariableValue".equals(child.getTagName())) {
                value = this.parseConditionExpressionVariableValue(child);
            }
            if (!StringUtils.hasText((String)value)) continue;
            valueList.add(value);
        }
        if (!"In".equals(operatorSymbol) && !"NotIn".equals(operatorSymbol) && valueList.size() > 1) {
            String first = (String)valueList.getFirst();
            valueList.clear();
            valueList.add(first);
        }
        return String.join((CharSequence)", ", valueList);
    }

    private String getElementText(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            return child.getTextContent() != null ? child.getTextContent().trim() : null;
        }
        return null;
    }

    private Element getFirstChildElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private void resetData(String queryPath) {
        this.selectList.clear();
        this.fromList.clear();
        this.orderByList.clear();
        this.returnFieldList.clear();
        this.tableAliasMap.clear();
        this.mainTableCache.clear();
        this.tableCounter = 1;
        this.queryProjectContext.remove();
        this.setIdContext(queryPath);
        this.caseWhenTableCache = null;
        this.inputMainTableColumnCache = null;
        this.caseInputCurrentTable = null;
        this.caseInputCurrentAlias = null;
        this.currentTable = null;
        this.currentAlias = null;
        this.caseTableCache.clear();
    }

    private void setIdContext(String queryPath) {
        Map<String, String> context = this.queryProjectContext.get();
        if (CollectionUtils.isEmpty(context)) {
            context = new HashMap<String, String>();
            this.queryProjectContext.set(context);
        }
        context.put("ID", queryPath);
    }

    private void setQueryEntityContext(String queryEntity) {
        Map<String, String> context = this.queryProjectContext.get();
        if (CollectionUtils.isEmpty(context)) {
            context = new HashMap<String, String>();
            this.queryProjectContext.set(context);
        }
        context.put("QueryEntity", queryEntity);
    }

    private void setConditionContext(Element condition) {
        Map<String, String> context = this.queryProjectContext.get();
        if (CollectionUtils.isEmpty(context)) {
            context = new HashMap<String, String>();
            this.queryProjectContext.set(context);
        }
        context.put("QueryViewColumn", null);
        context.put("Condition", this.transformer(condition));
    }

    private void setQueryViewColumnContext(Element column) {
        Map<String, String> context = this.queryProjectContext.get();
        if (CollectionUtils.isEmpty(context)) {
            context = new HashMap<String, String>();
            this.queryProjectContext.set(context);
        }
        context.put("QueryViewColumn", this.transformer(column));
    }

    public SqlParser() {
        try {
            if (null == this.e10Properties) {
                this.e10Properties = new E10Properties();
                this.e10Properties.setQueryBusinessObjectsRoot("E:\\e10\\query\\BusinessObjects");
            }
            MetadataParser metadataParser = new MetadataParser();
            metadataParser.parser();
            Map<String, DataEntity> entityMap = metadataParser.getEntityMap();
            entityMap.forEach((id, dataEntity) -> {
                for (DataProperty column : dataEntity.getColumns()) {
                    if (StringUtils.hasText((String)column.getAlias())) continue;
                    column.setAlias(column.getName());
                }
            });
            this.setMetaDataEntityMap(metadataParser.getEntityMap());
            this.setDicPropertyMap(metadataParser.getDicPropertyMap());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efa\u89e3\u6790\u5668\u5931\u8d25");
        }
    }

    public SqlParser(Map<String, DataEntity> metaDataEntityMap, Map<String, List<DicProperty>> dicPropertyMap) {
        try {
            if (null == this.e10Properties) {
                this.e10Properties = new E10Properties();
                this.e10Properties.setQueryBusinessObjectsRoot("E:\\e10\\query\\BusinessObjects");
            }
            metaDataEntityMap.forEach((id, dataEntity) -> {
                for (DataProperty column : dataEntity.getColumns()) {
                    if (StringUtils.hasText((String)column.getAlias())) continue;
                    column.setAlias(column.getName());
                }
            });
            this.setMetaDataEntityMap(metaDataEntityMap);
            this.setDicPropertyMap(dicPropertyMap);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efa\u89e3\u6790\u5668\u5931\u8d25");
        }
    }

    @Generated
    public List<SqlResult> getSqlResults() {
        return this.sqlResults;
    }

    @Generated
    public void setMetaDataEntityMap(Map<String, DataEntity> metaDataEntityMap) {
        this.metaDataEntityMap = metaDataEntityMap;
    }

    @Generated
    public void setDicPropertyMap(Map<String, List<DicProperty>> dicPropertyMap) {
        this.dicPropertyMap = dicPropertyMap;
    }
}

