/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils;

import com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.dto.SqlResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    private static final String DB_URL = "jdbc:sqlserver://172.16.7.64:1433;databaseName=E10_80_KF;encrypt=false;trustServerCertificate=true";
    private static final String DB_USER = "E10";
    private static final String DB_PASSWORD = "erpERP123";
    private static final String SQL_RESULTS = "sql_results.txt";

    public static void covertTxt(String inputFile, String outputFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class);
        List queries = (List)objectMapper.readValue(new File(inputFile), (JavaType)listType);
        StringBuilder output = new StringBuilder();
        for (Map query : queries) {
            output.append("code: ").append(query.get("code")).append("\n");
            output.append("source: ").append(query.get("source")).append("\n");
            output.append("description: ").append(query.get("description")).append("\n");
            output.append("executionResult: ").append(query.get("sqlExecutionResult")).append("\n");
            output.append("error: ").append(query.get("error")).append("\n");
            output.append("returnFields: ").append(query.get("returnFields")).append("\n");
            String sql = (String)query.get("sqlExample");
            sql = sql.replace("\\r\\n", "\n").replace("\\n", "\n").replace("\\t", "\t");
            output.append("sqlExample:\n").append(sql).append("\n");
            output.append("--------------------------------------------------------------------------------\n\n");
        }
        Files.write(Paths.get(outputFile, new String[0]), output.toString().getBytes(), new OpenOption[0]);
    }

    public static void covertTxt() throws IOException {
        String inputFile = "F:\\djworkspace\\ai-generate-tools\\sql_results.txt";
        String outputFile = "F:\\djworkspace\\ai-generate-tools\\sql_display.txt";
        SqlUtil.covertTxt(inputFile, outputFile);
    }

    public static void validateSqlExecute(List<SqlResult> sqlResults) {
        System.out.println("SQL\u68c0\u6d4b\u7ed3\u679c:");
        for (SqlResult result : sqlResults) {
            if (result.getSqlExample().startsWith("ERROR")) continue;
            SqlUtil.validateSql(result);
        }
    }

    private static void validateSql(SqlResult result) {
        String sql = result.getSqlExample();
        if (sql == null || sql.trim().isEmpty() || sql.startsWith("ERROR")) {
            result.setSqlExecutionResult("\u4e0d\u53ef\u6267\u884c\uff1asql\u4e3a\u7a7a");
            result.setIsExecutionSuccess(Boolean.FALSE);
            return;
        }
        String testSql = SqlUtil.adaptSqlForValidation(sql);
        try (Connection conn = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
             PreparedStatement stmt = conn.prepareStatement(testSql);){
            stmt.setQueryTimeout(10);
            try (ResultSet rs = stmt.executeQuery();){
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                result.setSqlExecutionResult("\u53ef\u6267\u884c");
                result.setIsExecutionSuccess(Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            System.err.println("---------------------------------------------------------------------------");
            System.err.println("SQL\uff1a" + result.getCode() + "\uff0c\u9a8c\u8bc1\u5931\u8d25,\u4e0d\u53ef\u6267\u884c,\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
            System.err.println("\u5931\u8d25SQL: ");
            System.err.println(sql);
            result.setSqlExecutionResult("\u4e0d\u53ef\u6267\u884c\uff1a" + e.getMessage());
            result.setIsExecutionSuccess(Boolean.FALSE);
        }
    }

    private static String adaptSqlForValidation(String originalSql) {
        String sql = originalSql.trim();
        if (sql.toUpperCase().startsWith("SELECT") && !sql.toUpperCase().contains(" TOP ") && !sql.toUpperCase().contains(" LIMIT ")) {
            int selectIndex = sql.toUpperCase().indexOf("SELECT");
            int fromIndex = sql.toUpperCase().indexOf("FROM");
            if (selectIndex >= 0 && fromIndex > selectIndex) {
                StringBuilder adaptedSql = new StringBuilder();
                adaptedSql.append(sql.substring(0, selectIndex + 6)).append(" TOP 1 ").append(sql.substring(selectIndex + 6));
                return adaptedSql.toString();
            }
        }
        return sql;
    }

    public static void writeTxt(List<SqlResult> sqlResults) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonResult = mapper.writeValueAsString(sqlResults);
        try (FileWriter writer = new FileWriter(SQL_RESULTS);){
            writer.write(jsonResult);
        }
    }

    public static String removeAsClause(String sqlString) {
        if (sqlString == null || sqlString.trim().isEmpty()) {
            return sqlString;
        }
        String regex = "\\s+[Aa][Ss]\\s+\\[[^]]*\\]$";
        String result = sqlString.replaceAll(regex, "");
        if (result.equals(sqlString)) {
            regex = "\\s+[Aa][Ss]\\s+[^\\s]+$";
            result = sqlString.replaceAll(regex, "");
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        String inputFile = "F:\\djworkspace\\ai-generate-tools\\sql_results.txt";
        String outputFile = "F:\\djworkspace\\ai-generate-tools\\sql_display.txt";
        SqlUtil.covertTxt(inputFile, outputFile);
    }

    static {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            System.out.println("SQL Server JDBC \u9a71\u52a8\u52a0\u8f7d\u6210\u529f");
        }
        catch (ClassNotFoundException e) {
            System.err.println("\u65e0\u6cd5\u52a0\u8f7d SQL Server JDBC \u9a71\u52a8: " + e.getMessage());
            throw new RuntimeException("JDBC \u9a71\u52a8\u52a0\u8f7d\u5931\u8d25", e);
        }
    }
}

