/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.parser.query.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StringBusinessUtil {
    public static String[] splitString(String input) {
        if (input == null || input.isEmpty()) {
            return new String[0];
        }
        String[] parts = input.split("\\.");
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < parts.length) {
            if (i + 1 < parts.length && "Parent".equals(parts[i + 1])) {
                StringBuilder combined = new StringBuilder(parts[i]);
                ++i;
                while (i < parts.length && "Parent".equals(parts[i])) {
                    combined.append(".").append(parts[i]);
                    ++i;
                }
                result.add(combined.toString());
                continue;
            }
            result.add(parts[i]);
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String getAfterFirstDot(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        int firstDotIndex = input.indexOf(46);
        if (firstDotIndex == -1) {
            return "";
        }
        return input.substring(firstDotIndex + 1);
    }

    public static String getParent(LinkedList<String> list, String str) {
        int index = list.indexOf(str);
        return index >= 0 ? list.get(index + 1) : null;
    }

    public static String getLastTwoPositionsOptimized(String str) {
        if (Objects.isNull(str) || str.isEmpty()) {
            return str;
        }
        int lastDotIndex = str.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return str;
        }
        int secondLastDotIndex = str.lastIndexOf(46, lastDotIndex - 1);
        if (secondLastDotIndex == -1) {
            return str;
        }
        return str.substring(secondLastDotIndex + 1);
    }

    public static String reverseDotSeparated(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] parts = input.split("\\.");
        return IntStream.range(0, parts.length).map(i -> parts.length - 1 - i).mapToObj(i -> parts[i]).collect(Collectors.joining("."));
    }

    public static boolean isNumeric(String str) {
        return str != null && !str.trim().isEmpty() && str.trim().matches("-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?");
    }

    public static void main(String[] args) {
        String test1 = "APPLY_FEATURE_PLANT_IPL.ITEM_FEATURE_ID.Parent.ITEM_SPECIFICATION";
        String test2 = "APPLY_FEATURE_PLANT_IPL.ITEM_FEATURE_ID.Parent.Parent.ITEM_SPECIFICATION";
        String test3 = "APPLY.APPLY_FEATURE_PLANT_IPL.ITEM_FEATURE_ID.Parent.ITEM_SPECIFICATION";
        String test4 = "Parent.Parent.ITEM_SPECIFICATION";
        System.out.println("\u6d4b\u8bd51\u7ed3\u679c:");
        for (String part : StringBusinessUtil.splitString(test1)) {
            System.out.println(part);
        }
        System.out.println("\n\u6d4b\u8bd52\u7ed3\u679c:");
        for (String part : StringBusinessUtil.splitString(test2)) {
            System.out.println(part);
        }
        System.out.println("\n\u6d4b\u8bd53\u7ed3\u679c:");
        for (String part : StringBusinessUtil.splitString(test3)) {
            System.out.println(part);
        }
        System.out.println("\n\u6d4b\u8bd54\u7ed3\u679c:");
        for (String part : StringBusinessUtil.splitString(test4)) {
            System.out.println(part);
        }
    }
}

