/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service;

import com.digiwin.athena.ai.generate.tools.common.service.CommonGenerateToolsService;
import com.digiwin.athena.ai.generate.tools.dto.GenerateHolder;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.enums.ProductEnum;
import com.digiwin.athena.ai.generate.tools.service.Step;
import jakarta.xml.bind.JAXBException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Service
public class E1081GenerateToolsServiceImpl
extends CommonGenerateToolsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E1081GenerateToolsServiceImpl.class);
    @Autowired
    private List<ObjectService> objectServices;

    public boolean condition(ProductEnum productEnum) {
        return ProductEnum.E10_8_1 == productEnum;
    }

    public GenerateHolder execute(GenerateRequestDTO generateRequestDTO) {
        List objectTypeEnumList = generateRequestDTO.getObjectTypeEnumList();
        E10ExecuteContext context = new E10ExecuteContext();
        if (!CollectionUtils.isEmpty((Collection)objectTypeEnumList)) {
            for (ObjectTypeEnum objectTypeEnum : objectTypeEnumList) {
                ObjectService objectService = this.objectServices.stream().filter(res -> res.objectTypeEnum() == objectTypeEnum && objectTypeEnum.getEnable() != false).findFirst().get();
                try {
                    objectService.execute(context, generateRequestDTO);
                }
                catch (Exception exception) {}
            }
        } else {
            List objectTypeEnums = Arrays.stream(ObjectTypeEnum.values()).filter(ObjectTypeEnum::getEnable).collect(Collectors.toList());
            this.objectServices.sort(Comparator.comparing(Step::stepIndex));
            for (ObjectService objectService : this.objectServices) {
                StopWatch stopWatch = new StopWatch();
                try {
                    stopWatch.start(generateRequestDTO.getProductNo() + "_" + generateRequestDTO.getVersion() + "-->" + objectService.desc());
                    if (!objectTypeEnums.contains(objectService.objectTypeEnum())) continue;
                    log.info("\u5f00\u59cb\u4ea7\u54c1\uff1a{}\uff0c\u7248\u672c\u53f7\uff1a{}\u5bf9\u5e94{}\u6570\u636e\u62bd\u53d6", new Object[]{generateRequestDTO.getProductNo(), generateRequestDTO.getVersion(), objectService.desc()});
                    objectService.execute(context, generateRequestDTO);
                    log.info("\u4ea7\u54c1\uff1a{}\uff0c\u7248\u672c\u53f7\uff1a{}\u5bf9\u5e94{}\u6570\u636e\u62bd\u53d6\u5df2\u5b8c\u6210", new Object[]{generateRequestDTO.getProductNo(), generateRequestDTO.getVersion(), objectService.desc()});
                    stopWatch.stop();
                    log.info(stopWatch.prettyPrint());
                }
                catch (JAXBException e) {
                    log.error("{}\u62bd\u53d6\u5904\u5f02\u5e38", (Object)objectService.desc());
                }
            }
        }
        return null;
    }

    public GenerateHolder clear(GenerateRequestDTO generateRequestDTO) {
        return super.clear(generateRequestDTO);
    }
}

