/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.generate.tools.e10.v8.service.objects;

import com.digiwin.athena.ai.generate.tools.db.bo.SclBusinessObject;
import com.digiwin.athena.ai.generate.tools.db.bo.SclProductVersion;
import com.digiwin.athena.ai.generate.tools.db.mapper.SclBusinessObjectMapper;
import com.digiwin.athena.ai.generate.tools.dto.GenerateRequestDTO;
import com.digiwin.athena.ai.generate.tools.e10.common.properties.E10Properties;
import com.digiwin.athena.ai.generate.tools.e10.util.FileLister;
import com.digiwin.athena.ai.generate.tools.e10.v8.E10ExecuteContext;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.business.RootEntity;
import com.digiwin.athena.ai.generate.tools.e10.v8.parser.module.dto.Item;
import com.digiwin.athena.ai.generate.tools.e10.v8.service.ObjectService;
import com.digiwin.athena.ai.generate.tools.enums.ObjectTypeEnum;
import com.digiwin.athena.ai.generate.tools.uitl.IdUtil;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10BusinessObjectServiceImpl
implements ObjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(E10BusinessObjectServiceImpl.class);
    @Autowired
    private E10Properties e10Properties;
    @Autowired
    private SclBusinessObjectMapper sclBusinessObjectMapper;

    @Override
    public ObjectTypeEnum objectTypeEnum() {
        return ObjectTypeEnum.BUSINESS;
    }

    @Override
    public void execute(E10ExecuteContext context, GenerateRequestDTO generateRequestDTO) throws JAXBException {
        Map<String, List<Item>> moduleItems = context.getModuleItems();
        List mergedItems = moduleItems.values().stream().filter(res -> CollectionUtils.isNotEmpty((Collection)res)).flatMap(res -> res.stream()).toList();
        SclProductVersion sclProductVersion = context.getSclProductVersion();
        List<RootEntity> rootNodeList = FileLister.getRootNodeList(this.e10Properties.getBusinessObjectsRoot(), this.e10Properties.getRootEntityFileName());
        context.setRootNodeList(rootNodeList);
        Map<String, List<Item>> collect = mergedItems.stream().collect(Collectors.groupingBy(Item::getTypeKey));
        ArrayList sclBusinessObjects = new ArrayList();
        collect.forEach((k, v) -> {
            SclBusinessObject sclBusinessObject = new SclBusinessObject();
            sclBusinessObject.setProductVersionId(sclProductVersion.getId());
            sclBusinessObject.setCode(k);
            sclBusinessObject.setId(IdUtil.getId());
            if (CollectionUtils.isNotEmpty((Collection)rootNodeList)) {
                Optional<RootEntity> first = rootNodeList.stream().filter(res -> k.equals(res.getFolderName())).findFirst();
                if (first.isPresent()) {
                    RootEntity rootEntity1 = first.get();
                    sclBusinessObject.setName(rootEntity1.getDisplayName());
                    sclBusinessObject.setDescription(rootEntity1.getDescription());
                } else {
                    sclBusinessObject.setName(((Item)v.getFirst()).getName());
                    sclBusinessObject.setDescription(((Item)v.getFirst()).getName());
                }
            } else {
                sclBusinessObject.setName(((Item)v.getFirst()).getName());
                sclBusinessObject.setDescription(((Item)v.getFirst()).getName());
            }
            sclBusinessObjects.add(sclBusinessObject);
        });
        if (CollectionUtils.isNotEmpty(sclBusinessObjects)) {
            this.sclBusinessObjectMapper.insert(sclBusinessObjects);
            Map<String, Long> moduleRel = context.getModuleRel();
            HashMap<String, Long> typeKeysModuleIdRel = new HashMap<String, Long>();
            moduleItems.forEach((k, v) -> {
                if (CollectionUtils.isNotEmpty((Collection)v)) {
                    List typeKeys = v.stream().map(Item::getTypeKey).collect(Collectors.toList());
                    for (String typeKey : typeKeys) {
                        typeKeysModuleIdRel.put(typeKey, (Long)moduleRel.get(k));
                    }
                }
            });
            context.setTypeKeysModuleIdRel(typeKeysModuleIdRel);
            Map<String, Long> businessObjectsRel = sclBusinessObjects.stream().collect(Collectors.toMap(SclBusinessObject::getCode, SclBusinessObject::getId, (existingValue, newValue) -> existingValue));
            context.setBusinessObjectsRel(businessObjectsRel);
        }
    }

    public Integer stepIndex() {
        return 3;
    }

    public String desc() {
        return "\u3010\u4e1a\u52a1\u5bf9\u8c61\u3011";
    }
}

